/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import java.io.IOException;

class DynamicKeySerializer
extends JsonSerializer<Object> {
    private final StdKeySerializer stdKeySerializer = new StdKeySerializer();
    private PropertySerializerMap serializerCache = PropertySerializerMap.emptyForRootValues();

    DynamicKeySerializer() {
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Class<?> valueClass = value.getClass();
        JsonSerializer ser = this.serializerCache.serializerFor(valueClass);
        if (ser == null) {
            JavaType type = serializers.getTypeFactory().constructType(valueClass);
            ser = serializers.findKeySerializer(type, null);
            if (ser.getClass() == DynamicKeySerializer.class) {
                ser = this.stdKeySerializer;
            }
            this.serializerCache.addSerializer(valueClass, ser);
        }
        ser.serialize(value, gen, serializers);
    }

    public Class<Object> handledType() {
        return Object.class;
    }
}

