/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Map;

public abstract class Attribute
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    protected final int startOffset;
    protected final int endOffset;

    protected Attribute(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    protected Attribute(int startOffset, int endOffset, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("startOffset", this.startOffset).add("endOffset", this.endOffset);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.endOffset != attribute.endOffset) {
            return false;
        }
        return this.startOffset == attribute.startOffset;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.startOffset;
        result = 31 * result + this.endOffset;
        return result;
    }

    public static abstract class Builder<T extends Attribute, B extends Builder<T, B>>
    extends BaseAttribute.Builder<Attribute, Builder<T, B>> {
        protected int startOffset;
        protected int endOffset;

        public Builder(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public Builder(Attribute toCopy) {
            super(toCopy);
            this.startOffset = toCopy.startOffset;
            this.endOffset = toCopy.endOffset;
        }

        @Override
        protected abstract B getThis();

        public B startOffset(int startOffset) {
            this.startOffset = startOffset;
            return (B)this.getThis();
        }

        public B endOffset(int endOffset) {
            this.endOffset = endOffset;
            return (B)this.getThis();
        }

        @Deprecated
        public B setEndOffset(int endOffset) {
            this.endOffset = endOffset;
            return (B)this.getThis();
        }
    }
}

