/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableList;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class CategorizerResult
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final String label;
    private final Double score;
    private final Double confidence;
    private final List<String> explanationSet;
    private final Map<String, Double> perFeatureScores;

    CategorizerResult(String label, Double score, Double confidence, List<String> explanationSet, Map<String, Double> perFeatureScores) {
        this(label, score, confidence, explanationSet, perFeatureScores, null);
    }

    CategorizerResult(String label, Double score, Double confidence, List<String> explanationSet, Map<String, Double> perFeatureScores, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.label = label;
        this.score = score;
        this.confidence = confidence;
        this.explanationSet = explanationSet == null ? null : ImmutableList.copyOf(explanationSet);
        this.perFeatureScores = perFeatureScores == null ? null : ImmutableMap.copyOf(perFeatureScores);
    }

    public String getLabel() {
        return this.label;
    }

    public Double getScore() {
        return this.score;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public List<String> getExplanationSet() {
        return this.explanationSet;
    }

    public Map<String, Double> getPerFeatureScores() {
        return this.perFeatureScores;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("label", this.label).add("score", this.score).add("confidence", this.confidence).add("explanationSet", this.explanationSet).add("perFeatureScores", this.perFeatureScores);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategorizerResult that = (CategorizerResult)o;
        if (this.confidence != null ? !this.confidence.equals(that.confidence) : that.confidence != null) {
            return false;
        }
        if (this.explanationSet != null ? !this.explanationSet.equals(that.explanationSet) : that.explanationSet != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.perFeatureScores != null ? !this.perFeatureScores.equals(that.perFeatureScores) : that.perFeatureScores != null) {
            return false;
        }
        return !(this.score == null ? that.score != null : !this.score.equals(that.score));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.score != null ? this.score.hashCode() : 0);
        result = 31 * result + (this.confidence != null ? this.confidence.hashCode() : 0);
        result = 31 * result + (this.explanationSet != null ? this.explanationSet.hashCode() : 0);
        result = 31 * result + (this.perFeatureScores != null ? this.perFeatureScores.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends BaseAttribute.Builder<CategorizerResult, Builder> {
        private String label;
        private Double score;
        private Double confidence;
        private List<String> explanationSet;
        private Map<String, Double> perFeatureScores;

        public Builder(String label, Double score) {
            this.label = label;
            this.score = score;
        }

        public Builder(CategorizerResult toCopy) {
            super(toCopy);
            this.label = toCopy.label;
            this.score = toCopy.score;
            this.confidence = toCopy.confidence;
            this.explanationSet = toCopy.explanationSet;
            this.perFeatureScores = toCopy.perFeatureScores;
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder explanationSet(List<String> explanationSet) {
            this.explanationSet = explanationSet;
            return this;
        }

        public Builder perFeatureScores(Map<String, Double> perFeatureScores) {
            this.perFeatureScores = perFeatureScores;
            return this;
        }

        public CategorizerResult build() {
            return new CategorizerResult(this.label, this.score, this.confidence, this.explanationSet, this.perFeatureScores, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

