/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.RosetteRuntimeException;
import com.basistech.rosette.dm.AttributeKey;
import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.Entity;
import com.basistech.rosette.dm.EntityMention;
import com.basistech.rosette.dm.ListAttribute;
import com.basistech.rosette.dm.Mention;
import com.basistech.rosette.dm.ResolvedEntity;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableMap;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

final class ConvertFromPreAdm11 {
    private ConvertFromPreAdm11() {
    }

    static Mention convertMention(EntityMention em) {
        Mention.Builder mentionBuilder = new Mention.Builder(em.getStartOffset(), em.getEndOffset());
        if (em.getConfidence() != null) {
            mentionBuilder.confidence(em.getConfidence());
        }
        if (em.getLinkingConfidence() != null) {
            mentionBuilder.linkingConfidence(em.getLinkingConfidence());
        }
        if (em.getFlags() != null && em.getFlags() != 0) {
            mentionBuilder.extendedProperty("oldFlags", em.getFlags());
        }
        if (em.getCoreferenceChainId() != null) {
            mentionBuilder.extendedProperty("oldCoreferenceChainId", em.getCoreferenceChainId());
        }
        if (em.getNormalized() != null) {
            mentionBuilder.normalized(em.getNormalized());
        }
        if (em.getSource() != null) {
            mentionBuilder.source(em.getSource());
        }
        if (em.getSubsource() != null) {
            mentionBuilder.subsource(em.getSubsource());
        }
        if (em.getExtendedProperties() != null && !em.getExtendedProperties().isEmpty()) {
            for (Map.Entry<String, Object> me : em.getExtendedProperties().entrySet()) {
                mentionBuilder.extendedProperty(me.getKey(), me.getValue());
            }
        }
        mentionBuilder.extendedProperty("old-entity-type", em.getEntityType());
        return mentionBuilder.build();
    }

    static void doResolvedConversion(ListAttribute<Entity> newResolved, ListAttribute<EntityMention> oldMentions, ListAttribute<ResolvedEntity> oldResolved, ImmutableMap.Builder<String, BaseAttribute> builder) {
        if (oldMentions == null) {
            ConvertFromPreAdm11.doNoMentionConversion(oldResolved, builder);
            return;
        }
        int maxChainId = -1;
        for (EntityMention entityMention : oldMentions) {
            if (entityMention.getCoreferenceChainId() == null) continue;
            maxChainId = Math.max(maxChainId, entityMention.getCoreferenceChainId());
        }
        maxChainId = Math.max(maxChainId, oldMentions.size());
        ResolvedEntity[] resolvedByChainId = new ResolvedEntity[maxChainId + 1];
        if (oldResolved != null) {
            for (ResolvedEntity resolvedEntity : oldResolved) {
                if (resolvedEntity.getCoreferenceChainId() != null) {
                    resolvedByChainId[resolvedEntity.getCoreferenceChainId().intValue()] = resolvedEntity;
                    continue;
                }
                throw new RosetteRuntimeException("Resolved entity with no coref chain id.");
            }
        }
        boolean bl = !oldMentions.isEmpty() && ((EntityMention)oldMentions.get(0)).getCoreferenceChainId() != null;
        int[] newIndices = new int[maxChainId + 1];
        int[] chainToIndex = new int[maxChainId + 1];
        Arrays.fill(chainToIndex, -1);
        int newEntityCount = 0;
        for (int oldIndex = 0; oldIndex < oldMentions.size(); ++oldIndex) {
            EntityMention em = (EntityMention)oldMentions.get(oldIndex);
            if (em.getCoreferenceChainId() != null && em.getCoreferenceChainId() != -1) {
                if (chainToIndex[em.getCoreferenceChainId()] == -1) {
                    chainToIndex[em.getCoreferenceChainId().intValue()] = newEntityCount++;
                }
                newIndices[oldIndex] = chainToIndex[em.getCoreferenceChainId()];
                continue;
            }
            newIndices[oldIndex] = newEntityCount++;
        }
        ArrayList<List<EntityMention>> mentionsByEntities = Lists.newArrayListWithExpectedSize(newEntityCount);
        for (int x = 0; x < newEntityCount; ++x) {
            mentionsByEntities.add(Lists.newArrayList());
        }
        int[] heads = new int[newEntityCount];
        for (int oldIndex = 0; oldIndex < oldMentions.size(); ++oldIndex) {
            EntityMention em = (EntityMention)oldMentions.get(oldIndex);
            int newIndex = newIndices[oldIndex];
            ((List)mentionsByEntities.get(newIndex)).add(em);
            if (em.getCoreferenceChainId() == null || em.getCoreferenceChainId() != oldIndex) continue;
            heads[newIndex] = ((List)mentionsByEntities.get(newIndex)).size() - 1;
        }
        ListAttribute.Builder<Entity> elBuilder = ConvertFromPreAdm11.buildEntities(newResolved, oldMentions, resolvedByChainId, bl, mentionsByEntities, heads);
        builder.put(AttributeKey.ENTITY.key(), elBuilder.build());
    }

    private static void doNoMentionConversion(ListAttribute<ResolvedEntity> oldResolved, ImmutableMap.Builder<String, BaseAttribute> builder) {
        ListAttribute.Builder<Entity> elBuilder = new ListAttribute.Builder<Entity>(Entity.class);
        for (ResolvedEntity resolvedEntity : oldResolved) {
            Entity.Builder enBuilder = new Entity.Builder();
            ConvertFromPreAdm11.convertOneEntity(enBuilder, resolvedEntity, null);
            elBuilder.add(enBuilder.build());
        }
        builder.put(AttributeKey.ENTITY.key(), elBuilder.build());
    }

    private static ListAttribute.Builder<Entity> buildEntities(ListAttribute<Entity> newResolved, ListAttribute<EntityMention> oldMentions, ResolvedEntity[] resolvedByChainId, boolean indocPresent, List<List<EntityMention>> mentionsByEntities, int[] heads) {
        ArrayList<Entity> entities = Lists.newArrayList();
        if (newResolved != null) {
            entities.addAll(newResolved);
        }
        int newIndex = 0;
        for (List<EntityMention> entityMentions : mentionsByEntities) {
            Entity.Builder builder = new Entity.Builder();
            String type = null;
            ArrayList<Mention> mentions = Lists.newArrayList();
            for (int x = 0; x < entityMentions.size(); ++x) {
                EntityMention em = entityMentions.get(x);
                if (x == heads[newIndex]) {
                    type = em.getEntityType();
                }
                Mention mention = ConvertFromPreAdm11.convertMention(em);
                mentions.add(mention);
            }
            Collections.sort(mentions, new Comparator<Mention>(){

                @Override
                public int compare(Mention o1, Mention o2) {
                    if (o1.getStartOffset() == o2.getStartOffset()) {
                        return o1.getEndOffset() - o2.getEndOffset();
                    }
                    return o1.getStartOffset() - o2.getStartOffset();
                }
            });
            for (Mention mention : mentions) {
                builder.mention(mention);
            }
            builder.type(type);
            EntityMention entityMention = entityMentions.get(0);
            ResolvedEntity resolvedEntity = null;
            if (entityMention.getCoreferenceChainId() != null && entityMention.getCoreferenceChainId() != -1) {
                resolvedEntity = resolvedByChainId[entityMention.getCoreferenceChainId()];
            }
            if (resolvedEntity != null) {
                ConvertFromPreAdm11.convertOneEntity(builder, resolvedEntity, entityMention.getCoreferenceChainId());
            } else if (entityMention.getCoreferenceChainId() != null) {
                builder.extendedProperty("oldCoreferenceChainId", entityMention.getCoreferenceChainId());
                builder.entityId(String.format("T%d", entityMention.getCoreferenceChainId()));
            }
            if (indocPresent) {
                builder.headMentionIndex(heads[newIndex]);
            }
            entities.add(builder.build());
            ++newIndex;
        }
        if (indocPresent) {
            Collections.sort(entities, new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    if (o1.getMentions() == null || o1.getMentions().size() == 0) {
                        if (o1.getMentions() == null || o2.getMentions().size() == 0) {
                            return 0;
                        }
                        return -1;
                    }
                    Mention m1 = o1.getMentions().get(0);
                    Mention m2 = o2.getMentions().get(0);
                    if (m1.getStartOffset() == m2.getStartOffset()) {
                        return m1.getEndOffset() - m2.getEndOffset();
                    }
                    return m1.getStartOffset() - m2.getStartOffset();
                }
            });
        }
        ListAttribute.Builder<Entity> elBuilder = new ListAttribute.Builder<Entity>(Entity.class);
        for (Entity entity : entities) {
            elBuilder.add(entity);
        }
        if (oldMentions.getExtendedProperties() != null) {
            for (Map.Entry entry : oldMentions.getExtendedProperties().entrySet()) {
                elBuilder.extendedProperty("mention." + (String)entry.getKey(), entry.getValue());
            }
        }
        if (newResolved != null && newResolved.getExtendedProperties().size() != 0) {
            for (Map.Entry entry : newResolved.getExtendedProperties().entrySet()) {
                elBuilder.extendedProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return elBuilder;
    }

    private static void convertOneEntity(Entity.Builder enBuilder, ResolvedEntity resolvedEntity, Integer indocChainId) {
        enBuilder.entityId(resolvedEntity.getEntityId());
        enBuilder.confidence(resolvedEntity.getConfidence());
        if (resolvedEntity.getSentiment() != null) {
            enBuilder.sentiment(resolvedEntity.getSentiment());
        }
        if (resolvedEntity.getExtendedProperties() != null) {
            for (Map.Entry<String, Object> me : resolvedEntity.getExtendedProperties().entrySet()) {
                enBuilder.extendedProperty(me.getKey(), me.getValue());
            }
        }
        if (resolvedEntity.getCoreferenceChainId() != null) {
            enBuilder.extendedProperty("oldCoreferenceChainId", resolvedEntity.getCoreferenceChainId());
            if (resolvedEntity.getEntityId() == null && indocChainId != null) {
                enBuilder.entityId(String.format("T%d", indocChainId));
            }
        }
    }
}

