/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class EmbeddingCollection
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final Map<Integer, float[]> embeddings;

    protected EmbeddingCollection(Map<Integer, float[]> embeddings) {
        this.embeddings = BaseAttribute.mapOrNull(embeddings);
    }

    public Map<Integer, float[]> getEmbeddings() {
        return this.embeddings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddingCollection that = (EmbeddingCollection)o;
        if (!this.embeddings.keySet().equals(that.embeddings.keySet())) {
            return false;
        }
        for (Map.Entry<Integer, float[]> me : this.embeddings.entrySet()) {
            if (Arrays.equals(me.getValue(), that.embeddings.get(me.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.embeddings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EmbeddingCollection{embeddings={");
        for (Map.Entry<Integer, float[]> me : this.embeddings.entrySet()) {
            sb.append(String.format("%d : %s,", me.getKey(), Arrays.toString(me.getValue())));
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private Map<Integer, float[]> embeddings = new HashMap<Integer, float[]>();

        public Builder() {
        }

        public Builder(EmbeddingCollection toCopy) {
            for (Map.Entry<Integer, float[]> me : toCopy.getEmbeddings().entrySet()) {
                this.embeddings.put(me.getKey(), (float[])me.getValue().clone());
            }
        }

        public Builder put(int index, float[] values) {
            this.embeddings.put(index, values);
            return this;
        }

        public Map<Integer, float[]> embeddings() {
            return this.embeddings;
        }

        public EmbeddingCollection build() {
            return new EmbeddingCollection(this.embeddings);
        }
    }
}

