/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.Token;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class MorphoAnalysis
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final String partOfSpeech;
    private final String lemma;
    private final List<Token> components;
    private final String raw;

    protected MorphoAnalysis(String partOfSpeech, String lemma, List<Token> components, String raw, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.partOfSpeech = partOfSpeech;
        this.lemma = lemma;
        this.components = MorphoAnalysis.listOrNull(components);
        this.raw = raw;
    }

    public String getPartOfSpeech() {
        return this.partOfSpeech;
    }

    public String getLemma() {
        return this.lemma;
    }

    public List<Token> getComponents() {
        return this.components;
    }

    public String getRaw() {
        return this.raw;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MorphoAnalysis that = (MorphoAnalysis)o;
        if (this.components != null ? !this.components.equals(that.components) : that.components != null) {
            return false;
        }
        if (this.lemma != null ? !this.lemma.equals(that.lemma) : that.lemma != null) {
            return false;
        }
        if (this.partOfSpeech != null ? !this.partOfSpeech.equals(that.partOfSpeech) : that.partOfSpeech != null) {
            return false;
        }
        return !(this.raw == null ? that.raw != null : !this.raw.equals(that.raw));
    }

    @Override
    public int hashCode() {
        int result = this.partOfSpeech != null ? this.partOfSpeech.hashCode() : 0;
        result = 31 * result + (this.lemma != null ? this.lemma.hashCode() : 0);
        result = 31 * result + (this.components != null ? this.components.hashCode() : 0);
        result = 31 * result + (this.raw != null ? this.raw.hashCode() : 0);
        return result;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("partOfSpeech", this.partOfSpeech).add("lemma", this.lemma).add("components", this.components).add("raw", this.raw);
    }

    @Override
    public String toString() {
        return this.toStringHelper().toString();
    }

    public static class Builder<T extends MorphoAnalysis, B extends Builder<T, B>>
    extends BaseAttribute.Builder<MorphoAnalysis, Builder<T, B>> {
        protected String partOfSpeech;
        protected String lemma;
        protected List<Token> components = Lists.newArrayList();
        protected String raw;

        public Builder() {
            this.raw = null;
            this.lemma = null;
            this.partOfSpeech = null;
        }

        public Builder(MorphoAnalysis toCopy) {
            super(toCopy);
            this.partOfSpeech = toCopy.partOfSpeech;
            this.lemma = toCopy.lemma;
            Builder.addAllToList(this.components, toCopy.components);
            this.raw = toCopy.raw;
        }

        public B partOfSpeech(String partOfSpeech) {
            this.partOfSpeech = partOfSpeech;
            return (B)this.getThis();
        }

        public B lemma(String lemma) {
            this.lemma = lemma;
            return (B)this.getThis();
        }

        public B raw(String raw) {
            this.raw = raw;
            return (B)this.getThis();
        }

        public B addComponent(Token component) {
            this.components.add(component);
            return (B)this.getThis();
        }

        public B components(List<Token> components) {
            this.components = Builder.nullOrList(components);
            return (B)this.getThis();
        }

        public MorphoAnalysis build() {
            return new MorphoAnalysis(this.partOfSpeech, this.lemma, this.components, this.raw, this.buildExtendedProperties());
        }

        @Override
        protected B getThis() {
            return (B)this;
        }
    }
}

