/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.Attribute;
import com.basistech.rosette.dm.MorphoAnalysis;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class Token
extends Attribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final String text;
    private final List<String> normalized;
    private final List<MorphoAnalysis> analyses;
    private final String source;

    protected Token(int startOffset, int endOffset, String text, List<String> normalized, String source, List<MorphoAnalysis> analyses, Map<String, Object> extendedProperties) {
        super(startOffset, endOffset, extendedProperties);
        this.text = text;
        this.normalized = Token.listOrNull(normalized);
        this.source = source;
        this.analyses = Token.listOrNull(analyses);
    }

    public String getText() {
        return this.text;
    }

    public List<String> getNormalized() {
        return this.normalized;
    }

    public List<MorphoAnalysis> getAnalyses() {
        return this.analyses;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Token token = (Token)o;
        if (this.analyses != null ? !this.analyses.equals(token.analyses) : token.analyses != null) {
            return false;
        }
        if (this.normalized != null ? !this.normalized.equals(token.normalized) : token.normalized != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(token.source) : token.source != null) {
            return false;
        }
        return !(this.text == null ? token.text != null : !this.text.equals(token.text));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.text.hashCode();
        if (this.normalized != null) {
            result = 31 * result + this.normalized.hashCode();
        }
        if (this.analyses != null) {
            result = 31 * result + this.analyses.hashCode();
        }
        if (this.source != null) {
            result = 31 * result + this.source.hashCode();
        }
        return result;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("text", this.text).add("normalized", this.normalized).add("analyses", this.analyses).add("source", this.source);
    }

    public static class Builder
    extends Attribute.Builder<Token, Builder> {
        private String text;
        private List<String> normalized;
        private List<MorphoAnalysis> analyses;
        private String source;

        public Builder(int startOffset, int endOffset, String text) {
            super(startOffset, endOffset);
            this.text = text;
            this.analyses = Lists.newArrayList();
            this.source = null;
            this.normalized = Lists.newArrayList();
        }

        public Builder(Token toCopy) {
            super(toCopy);
            this.text = toCopy.text;
            this.normalized = Lists.newArrayList();
            this.analyses = Lists.newArrayList();
            Builder.addAllToList(this.normalized, toCopy.normalized);
            Builder.addAllToList(this.analyses, toCopy.getAnalyses());
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder addNormalized(String normalized) {
            this.normalized.add(normalized);
            return this;
        }

        public Builder normalized(List<String> normalized) {
            this.normalized = Builder.nullOrList(normalized);
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder addAnalysis(MorphoAnalysis analysis) {
            this.analyses.add(analysis);
            return this;
        }

        public Builder analyses(List<MorphoAnalysis> analyses) {
            this.analyses = Builder.nullOrList(analyses);
            return this;
        }

        public Token build() {
            return new Token(this.startOffset, this.endOffset, this.text, this.normalized, this.source, this.analyses, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

