/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.util.TextDomain;
import java.io.Serializable;
import java.util.Map;

public class TranslatedData
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final TextDomain domain;
    private final String translation;
    private final Double confidence;

    protected TranslatedData(TextDomain domain, String translation, Double confidence, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.domain = domain;
        this.translation = translation;
        this.confidence = confidence;
    }

    public TextDomain getDomain() {
        return this.domain;
    }

    public String getTranslation() {
        return this.translation;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TranslatedData that = (TranslatedData)o;
        if (this.confidence != null ? !this.confidence.equals(that.confidence) : that.confidence != null) {
            return false;
        }
        if (!this.domain.equals((Object)that.domain)) {
            return false;
        }
        return this.translation.equals(that.translation);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + this.translation.hashCode();
        result = 31 * result + (this.confidence != null ? this.confidence.hashCode() : 0);
        return result;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add("domain", this.domain).add("translation", this.translation);
        if (this.confidence != null) {
            helper.add("confidence", this.confidence);
        }
        return helper;
    }

    public static class Builder
    extends BaseAttribute.Builder<TranslatedData, Builder> {
        private TextDomain domain;
        private String translation;
        private Double confidence;

        public Builder(TextDomain domain, String translation) {
            this.domain = domain;
            this.translation = translation;
        }

        public Builder(TranslatedData toCopy) {
            super(toCopy);
            this.domain = toCopy.domain;
            this.translation = toCopy.getTranslation();
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public TranslatedData build() {
            return new TranslatedData(this.domain, this.translation, this.confidence, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

