/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import com.basistech.util.TextDomain;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class TranslatedTokens
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final TextDomain domain;
    private final List<String> translations;

    protected TranslatedTokens(TextDomain domain, List<String> translations, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.domain = domain;
        this.translations = TranslatedTokens.listOrNull(translations);
    }

    public TextDomain getDomain() {
        return this.domain;
    }

    public List<String> getTranslations() {
        return this.translations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TranslatedTokens that = (TranslatedTokens)o;
        if (this.domain != null ? !this.domain.equals((Object)that.domain) : that.domain != null) {
            return false;
        }
        return !(this.translations == null ? that.translations != null : !this.translations.equals(that.translations));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (this.translations != null ? this.translations.hashCode() : 0);
        return result;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("domain", this.domain).add("translations", this.translations);
    }

    public static class Builder
    extends BaseAttribute.Builder<TranslatedTokens, Builder> {
        private TextDomain domain;
        private List<String> translations;

        public Builder(TextDomain domain) {
            this.domain = domain;
            this.translations = Lists.newArrayList();
        }

        public Builder(TranslatedTokens toCopy) {
            super(toCopy);
            this.domain = toCopy.domain;
            this.translations = Lists.newArrayList();
            Builder.addAllToList(this.translations, toCopy.getTranslations());
        }

        public Builder addTranslatedToken(String translatedToken) {
            this.translations.add(translatedToken);
            return this;
        }

        public Builder translatedTokens(List<String> translations) {
            this.translations = Builder.nullOrList(translations);
            return this;
        }

        public TranslatedTokens build() {
            return new TranslatedTokens(this.domain, this.translations, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

