/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.MorphoAnalysis;
import com.basistech.rosette.dm.Token;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class ArabicMorphoAnalysis
extends MorphoAnalysis
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final int prefixLength;
    private final int stemLength;
    private final String root;
    private final boolean definiteArticle;
    private final boolean strippablePrefix;
    private final List<String> prefixes;
    private final List<String> stems;
    private final List<String> suffixes;
    private final List<String> prefixTags;
    private final List<String> stemTags;
    private final List<String> suffixTags;

    protected ArabicMorphoAnalysis(String partOfSpeech, String lemma, List<Token> components, String raw, int prefixLength, int stemLength, String root, boolean definiteArticle, boolean strippablePrefix, List<String> prefixes, List<String> stems, List<String> suffixes, List<String> prefixTags, List<String> stemTags, List<String> suffixTags, Map<String, Object> extendedProperties) {
        super(partOfSpeech, lemma, components, raw, extendedProperties);
        this.prefixLength = prefixLength;
        this.stemLength = stemLength;
        this.root = root;
        this.prefixes = ArabicMorphoAnalysis.listOrNull(prefixes);
        this.stems = ArabicMorphoAnalysis.listOrNull(stems);
        this.suffixes = ArabicMorphoAnalysis.listOrNull(suffixes);
        this.prefixTags = ArabicMorphoAnalysis.listOrNull(prefixTags);
        this.stemTags = ArabicMorphoAnalysis.listOrNull(stemTags);
        this.suffixTags = ArabicMorphoAnalysis.listOrNull(suffixTags);
        this.definiteArticle = definiteArticle;
        this.strippablePrefix = strippablePrefix;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int getStemLength() {
        return this.stemLength;
    }

    public String getRoot() {
        return this.root;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public List<String> getStems() {
        return this.stems;
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    public List<String> getPrefixTags() {
        return this.prefixTags;
    }

    public List<String> getStemTags() {
        return this.stemTags;
    }

    public List<String> getSuffixTags() {
        return this.suffixTags;
    }

    public boolean isDefiniteArticle() {
        return this.definiteArticle;
    }

    public boolean isStrippablePrefix() {
        return this.strippablePrefix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArabicMorphoAnalysis that = (ArabicMorphoAnalysis)o;
        if (this.definiteArticle != that.definiteArticle) {
            return false;
        }
        if (this.prefixLength != that.prefixLength) {
            return false;
        }
        if (this.stemLength != that.stemLength) {
            return false;
        }
        if (this.strippablePrefix != that.strippablePrefix) {
            return false;
        }
        if (this.prefixTags != null ? !this.prefixTags.equals(that.prefixTags) : that.prefixTags != null) {
            return false;
        }
        if (this.prefixes != null ? !this.prefixes.equals(that.prefixes) : that.prefixes != null) {
            return false;
        }
        if (this.root != null ? !this.root.equals(that.root) : that.root != null) {
            return false;
        }
        if (this.stemTags != null ? !this.stemTags.equals(that.stemTags) : that.stemTags != null) {
            return false;
        }
        if (this.stems != null ? !this.stems.equals(that.stems) : that.stems != null) {
            return false;
        }
        if (this.suffixTags != null ? !this.suffixTags.equals(that.suffixTags) : that.suffixTags != null) {
            return false;
        }
        return !(this.suffixes == null ? that.suffixes != null : !this.suffixes.equals(that.suffixes));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.prefixLength;
        result = 31 * result + this.stemLength;
        result = 31 * result + (this.root != null ? this.root.hashCode() : 0);
        result = 31 * result + (this.definiteArticle ? 1 : 0);
        result = 31 * result + (this.strippablePrefix ? 1 : 0);
        result = 31 * result + (this.prefixes != null ? this.prefixes.hashCode() : 0);
        result = 31 * result + (this.stems != null ? this.stems.hashCode() : 0);
        result = 31 * result + (this.suffixes != null ? this.suffixes.hashCode() : 0);
        result = 31 * result + (this.prefixTags != null ? this.prefixTags.hashCode() : 0);
        result = 31 * result + (this.stemTags != null ? this.stemTags.hashCode() : 0);
        result = 31 * result + (this.suffixTags != null ? this.suffixTags.hashCode() : 0);
        return result;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("prefixLength", this.prefixLength).add("stemLength", this.stemLength).add("root", this.root).add("definiteArticle", this.definiteArticle).add("strippablePrefix", this.strippablePrefix).add("prefixes", this.prefixes).add("stems", this.stems).add("suffixes", this.suffixes).add("prefixTags", this.prefixTags).add("stemTags", this.stemTags).add("suffixTags", this.suffixTags);
    }

    public static class Builder
    extends MorphoAnalysis.Builder<ArabicMorphoAnalysis, Builder> {
        private int prefixLength;
        private int stemLength;
        private String root;
        private boolean definiteArticle;
        private boolean strippablePrefix;
        private List<String> prefixes = Lists.newArrayList();
        private List<String> stems = Lists.newArrayList();
        private List<String> suffixes = Lists.newArrayList();
        private List<String> prefixTags = Lists.newArrayList();
        private List<String> stemTags = Lists.newArrayList();
        private List<String> suffixTags = Lists.newArrayList();

        public Builder() {
            this.root = null;
        }

        public Builder(ArabicMorphoAnalysis toCopy) {
            super(toCopy);
            Builder.addAllToList(this.prefixes, toCopy.prefixes);
            Builder.addAllToList(this.stems, toCopy.stems);
            Builder.addAllToList(this.suffixes, toCopy.suffixes);
            Builder.addAllToList(this.prefixTags, toCopy.prefixTags);
            Builder.addAllToList(this.stemTags, toCopy.stemTags);
            Builder.addAllToList(this.suffixTags, toCopy.suffixTags);
        }

        public Builder lengths(int prefixLength, int stemLength) {
            this.prefixLength = prefixLength;
            this.stemLength = stemLength;
            return this;
        }

        public Builder root(String root) {
            this.root = root;
            return this;
        }

        public Builder definiteArticle(boolean definiteArticle) {
            this.definiteArticle = definiteArticle;
            return this;
        }

        public Builder strippablePrefix(boolean strippablePrefix) {
            this.strippablePrefix = strippablePrefix;
            return this;
        }

        public Builder addPrefix(String prefix, String prefixTag) {
            this.prefixes.add(prefix);
            this.prefixTags.add(prefixTag);
            return this;
        }

        public Builder prefixes(List<String> prefixes, List<String> prefixTags) {
            this.prefixes = Builder.nullOrList(prefixes);
            this.prefixTags = Builder.nullOrList(prefixTags);
            return this;
        }

        public Builder addStem(String stem, String stemTag) {
            this.stems.add(stem);
            this.stemTags.add(stemTag);
            return this;
        }

        public Builder stems(List<String> stems, List<String> stemTags) {
            this.stems = Builder.nullOrList(stems);
            this.stemTags = Builder.nullOrList(stemTags);
            return this;
        }

        public Builder addSuffix(String suffix, String suffixTag) {
            this.suffixes.add(suffix);
            this.suffixTags.add(suffixTag);
            return this;
        }

        public Builder suffixes(List<String> suffixes, List<String> suffixTags) {
            this.suffixes = Builder.nullOrList(suffixes);
            this.suffixTags = Builder.nullOrList(suffixTags);
            return this;
        }

        @Override
        public ArabicMorphoAnalysis build() {
            return new ArabicMorphoAnalysis(this.partOfSpeech, this.lemma, this.components, this.raw, this.prefixLength, this.stemLength, this.root, this.definiteArticle, this.strippablePrefix, this.prefixes, this.stems, this.suffixes, this.prefixTags, this.stemTags, this.suffixTags, this.buildExtendedProperties());
        }
    }
}

