/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.MorphoAnalysis;
import com.basistech.rosette.dm.Token;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class HanMorphoAnalysis
extends MorphoAnalysis
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final List<String> readings;

    protected HanMorphoAnalysis(String partOfSpeech, String lemma, List<Token> components, String raw, List<String> readings, Map<String, Object> extendedProperties) {
        super(partOfSpeech, lemma, components, raw, extendedProperties);
        this.readings = HanMorphoAnalysis.listOrNull(readings);
    }

    public List<String> getReadings() {
        return this.readings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HanMorphoAnalysis that = (HanMorphoAnalysis)o;
        if (this.readings == null) {
            return that.readings == null;
        }
        return this.readings.equals(that.readings);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.readings != null) {
            result = 31 * result + this.readings.hashCode();
        }
        return result;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("readings", this.readings);
    }

    public static class Builder
    extends MorphoAnalysis.Builder<HanMorphoAnalysis, Builder> {
        private List<String> readings = Lists.newArrayList();

        public Builder() {
        }

        public Builder(HanMorphoAnalysis toCopy) {
            super(toCopy);
            Builder.addAllToList(this.readings, toCopy.getReadings());
        }

        public Builder addReading(String reading) {
            this.readings.add(reading);
            return this;
        }

        public Builder readings(List<String> readings) {
            this.readings = Builder.nullOrList(readings);
            return this;
        }

        @Override
        public HanMorphoAnalysis build() {
            return new HanMorphoAnalysis(this.partOfSpeech, this.lemma, this.components, this.raw, this.readings, this.buildExtendedProperties());
        }
    }
}

