/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import java.io.Serializable;
import java.util.Map;

public class Name
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final String text;
    private final String type;
    private final ISO15924 script;
    private final LanguageCode languageOfOrigin;
    private final LanguageCode languageOfUse;

    Name() {
        this.text = "";
        this.type = null;
        this.script = ISO15924.Zyyy;
        this.languageOfUse = LanguageCode.UNKNOWN;
        this.languageOfOrigin = LanguageCode.UNKNOWN;
    }

    protected Name(String text, String type, ISO15924 script, LanguageCode languageOfOrigin, LanguageCode languageOfUse, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.text = text == null ? "" : text;
        this.type = type;
        this.script = script == null ? ISO15924.Zyyy : script;
        this.languageOfOrigin = languageOfOrigin == null ? LanguageCode.UNKNOWN : languageOfOrigin;
        this.languageOfUse = languageOfUse == null ? LanguageCode.UNKNOWN : languageOfUse;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public ISO15924 getScript() {
        return this.script;
    }

    public LanguageCode getLanguageOfOrigin() {
        return this.languageOfOrigin;
    }

    public LanguageCode getLanguageOfUse() {
        return this.languageOfUse;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Name name = (Name)o;
        if (this.languageOfOrigin != name.languageOfOrigin) {
            return false;
        }
        if (this.languageOfUse != name.languageOfUse) {
            return false;
        }
        if (this.script != name.script) {
            return false;
        }
        if (!this.text.equals(name.text)) {
            return false;
        }
        return !(this.type == null ? name.type != null : !this.type.equals(name.type));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.text.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.script.hashCode();
        result = 31 * result + this.languageOfOrigin.hashCode();
        result = 31 * result + this.languageOfUse.hashCode();
        return result;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        MoreObjects.ToStringHelper builder = super.toStringHelper().add("text", this.text);
        if (this.type != null) {
            builder.add("type", this.type);
        }
        if (this.script != null && this.script != ISO15924.Zyyy) {
            builder.add("script", this.script.code4());
        }
        if (this.languageOfUse != null && this.languageOfUse != LanguageCode.UNKNOWN) {
            builder.add("languageOfUse", this.languageOfUse.ISO639_3());
        }
        if (this.languageOfOrigin != null && this.languageOfOrigin != LanguageCode.UNKNOWN) {
            builder.add("languageOfOrigin", this.languageOfOrigin.ISO639_3());
        }
        return builder;
    }

    public static class Builder
    extends BaseAttribute.Builder<Name, Builder> {
        private String text;
        private String type;
        private ISO15924 script;
        private LanguageCode languageOfUse;
        private LanguageCode languageOfOrigin;

        public Builder(String text) {
            this.text = text;
            this.script = ISO15924.Zyyy;
            this.languageOfOrigin = LanguageCode.UNKNOWN;
            this.languageOfUse = LanguageCode.UNKNOWN;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder script(ISO15924 script) {
            this.script = script;
            return this;
        }

        public Builder languageOfUse(LanguageCode languageOfUse) {
            this.languageOfUse = languageOfUse;
            return this;
        }

        public Builder languageOfOrigin(LanguageCode languageOfOrigin) {
            this.languageOfOrigin = languageOfOrigin;
            return this;
        }

        public Name build() {
            return new Name(this.text, this.type, this.script, this.languageOfOrigin, this.languageOfUse, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

