/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import java.io.Serializable;
import java.util.Objects;

public class SimilarTerm
extends BaseAttribute
implements Serializable {
    private final String term;
    private final Double similarity;

    protected SimilarTerm(String term, Double similarity) {
        this.term = term;
        this.similarity = similarity;
    }

    public String getTerm() {
        return this.term;
    }

    public Double getSimilarity() {
        return this.similarity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimilarTerm that = (SimilarTerm)o;
        return Objects.equals(this.term, that.term) && Objects.equals(this.similarity, that.similarity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term, this.similarity);
    }

    @Override
    public String toString() {
        return String.format("SimilarTerm{term=%s; similarity=%s}", this.term, this.similarity);
    }

    public static class Builder
    extends BaseAttribute.Builder<SimilarTerm, Builder> {
        private String term = null;
        private Double similarity = null;

        public Builder term(String term) {
            this.term = term;
            return this;
        }

        public Builder similarity(Double similarity) {
            this.similarity = similarity;
            return this;
        }

        public SimilarTerm build() {
            return new SimilarTerm(this.term, this.similarity);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

