/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util;

public enum ISO15924 {
    Afak(439, "Afaka"),
    Aghb(239, "Caucasian Albanian"),
    Ahom(338, "Ahom, Tai Ahom"),
    Arab(160, "Arabic"),
    Armi(124, "Imperial Aramaic"),
    Armn(230, "Armenian"),
    Avst(134, "Avestan"),
    Bali(360, "Balinese"),
    Bamu(435, "Bamum"),
    Bass(259, "Bassa Vah"),
    Batk(365, "Batak"),
    Beng(325, "Bengali"),
    Blis(550, "Blissymbols"),
    Bopo(285, "Bopomofo"),
    Brah(300, "Brahmi"),
    Brai(570, "Braille"),
    Bugi(367, "Buginese"),
    Buhd(372, "Buhid"),
    Cakm(349, "Chakma"),
    Cans(440, "Unified Canadian Aboriginal Syllabics"),
    Cari(201, "Carian"),
    Cham(358, "Cham"),
    Cher(445, "Cherokee"),
    Cirt(291, "Cirth"),
    Copt(204, "Coptic"),
    Cprt(403, "Cypriot"),
    Cyrl(220, "Cyrillic"),
    Cyrs(221, "Cyrillic (Old Church Slavonic variant)"),
    Deva(315, "Devanagari (Nagari)"),
    Dsrt(250, "Deseret (Mormon)"),
    Dupl(755, "Duployan shorthand, Duployan stenography"),
    Egyd(70, "Egyptian demotic"),
    Egyh(60, "Egyptian hieratic"),
    Egyp(50, "Egyptian hieroglyphs"),
    Elba(226, "Elbasan"),
    Ethi(430, "Ethiopic (Ge\u02bbez)"),
    Geor(240, "Georgian (Mkhedruli)"),
    Geok(241, "Khutsuri (Asomtavruli and Nuskhuri)"),
    Glag(225, "Glagolitic"),
    Goth(206, "Gothic"),
    Gran(343, "Grantha"),
    Grek(200, "Greek"),
    Gujr(320, "Gujarati"),
    Guru(310, "Gurmukhi"),
    Hang(286, "Hangul (Hang\u016dl, Hangeul)"),
    Hani(500, "Han (Hanzi, Kanji, Hanja)"),
    Hano(371, "Hanunoo (Hanun\u00f3o)"),
    Hans(501, "Han (Simplified variant)"),
    Hant(502, "Han (Traditional variant)"),
    Hatr(127, "Hatran"),
    Hebr(125, "Hebrew"),
    Hira(410, "Hiragana"),
    Hluw(80, "Anatolian Hieroglyphs (Luwian Hieroglyphs, Hittite Hieroglyphs)"),
    Hmng(450, "Pahawh Hmong"),
    Hrkt(412, "Japanese syllabaries (alias for Hiragana + Katakana)"),
    Hung(176, "Old Hungarian (Hungarian Runic)"),
    Inds(610, "Indus (Harappan)"),
    Ital(210, "Old Italic (Etruscan, Oscan, etc.)"),
    Java(361, "Javanese"),
    Jpan(413, "Japanese (alias for Han + Hiragana + Katakana)"),
    Jurc(510, "Jurchen"),
    Kali(357, "Kayah Li"),
    Kana(411, "Katakana"),
    Khar(305, "Kharoshthi"),
    Khmr(355, "Khmer"),
    Khoj(322, "Khojki"),
    Knda(345, "Kannada"),
    Kore(287, "Korean (alias for Hangul + Han)"),
    Kpel(436, "Kpelle"),
    Kthi(317, "Kaithi"),
    Lana(351, "Tai Tham (Lanna)"),
    Laoo(356, "Lao"),
    Latf(217, "Latin (Fraktur variant)"),
    Latg(216, "Latin (Gaelic variant)"),
    Latn(215, "Latin"),
    Lepc(335, "Lepcha (R\u00f3ng)"),
    Limb(336, "Limbu"),
    Lina(400, "Linear A"),
    Linb(401, "Linear B"),
    Lisu(399, "Lisu (Fraser)"),
    Loma(437, "Loma"),
    Lyci(202, "Lycian"),
    Lydi(116, "Lydian"),
    Mahj(314, "Mahajani"),
    Mand(140, "Mandaic, Mandaean"),
    Mani(139, "Manichaean"),
    Maya(90, "Mayan hieroglyphs"),
    Mend(438, "Mende Kikakui"),
    Merc(101, "Meroitic Cursive"),
    Mero(100, "Meroitic Hieroglyphs"),
    Mlym(347, "Malayalam"),
    Modi(323, "Modi, Mo\u1e0d\u012b"),
    Moon(218, "Moon (Moon code, Moon script, Moon type)"),
    Mong(145, "Mongolian"),
    Mroo(199, "Mro, Mru"),
    Mtei(337, "Meitei Mayek (Meithei, Meetei)"),
    Mult(323, " Multani"),
    Mymr(350, "Myanmar (Burmese)"),
    Narb(106, "Old North Arabian (Ancient North Arabian)"),
    Nbat(159, "Nabataean"),
    Nkgb(420, "Nakhi Geba ('Na-'Khi \u00b2Gg\u014f-\u00b9baw, Naxi Geba)"),
    Nkoo(165, "N\u2019Ko"),
    Nshu(499, "N\u00fcshu"),
    Ogam(212, "Ogham"),
    Olck(261, "Ol Chiki (Ol Cemet\u2019, Ol, Santali)"),
    Orkh(175, "Old Turkic, Orkhon Runic"),
    Orya(327, "Oriya"),
    Osma(260, "Osmanya"),
    Palm(126, "Palmyrene"),
    Pauc(263, "Pau Cin Hau"),
    Perm(227, "Old Permic"),
    Phag(331, "Phags-pa"),
    Phli(131, "Inscriptional Pahlavi"),
    Phlp(132, "Psalter Pahlavi"),
    Phlv(133, "Book Pahlavi"),
    Phnx(115, "Phoenician"),
    Plrd(282, "Miao (Pollard)"),
    Prti(130, "Inscriptional Parthian"),
    Qaaa(900, "Reserved for private use (start)"),
    Qabx(949, "Reserved for private use (end)"),
    Rjng(363, "Rejang (Redjang, Kaganga)"),
    Roro(620, "Rongorongo"),
    Runr(211, "Runic"),
    Samr(123, "Samaritan"),
    Sara(292, "Sarati"),
    Sarb(105, "Old South Arabian"),
    Saur(344, "Saurashtra"),
    Sgnw(95, "SignWriting"),
    Shaw(281, "Shavian (Shaw)"),
    Shrd(319, "Sharada, \u015a\u0101rad\u0101"),
    Sidd(302, "Siddham, Siddha\u1e43, Siddham\u0101t\u1e5bk\u0101"),
    Sind(318, "Khudawadi, Sindhi"),
    Sinh(348, "Sinhala"),
    Sora(398, "Sora Sompeng"),
    Sund(362, "Sundanese"),
    Sylo(316, "Syloti Nagri"),
    Syrc(135, "Syriac"),
    Syre(138, "Syriac (Estrangelo variant)"),
    Syrj(137, "Syriac (Western variant)"),
    Syrn(136, "Syriac (Eastern variant)"),
    Tagb(373, "Tagbanwa"),
    Takr(321, "Takri, \u1e6c\u0101kr\u012b, \u1e6c\u0101\u1e45kr\u012b"),
    Tale(353, "Tai Le"),
    Talu(354, "New Tai Lue"),
    Taml(346, "Tamil"),
    Tang(520, "Tangut"),
    Tavt(359, "Tai Viet"),
    Telu(340, "Telugu"),
    Teng(290, "Tengwar"),
    Tfng(120, "Tifinagh (Berber)"),
    Tglg(370, "Tagalog (Baybayin, Alibata)"),
    Thaa(170, "Thaana"),
    Thai(352, "Thai"),
    Tibt(330, "Tibetan"),
    Tirh(326, "Tirhuta"),
    Ugar(40, "Ugaritic"),
    Vaii(470, "Vai"),
    Visp(280, "Visible Speech"),
    Wara(262, "Warang Citi (Varang Kshiti)"),
    Wole(480, "Woleai"),
    Xpeo(30, "Old Persian"),
    Xsux(20, "Cuneiform, Sumero-Akkadian"),
    Yiii(460, "Yi"),
    Zinh(994, "Code for inherited script"),
    Zmth(995, "Mathematical notation"),
    Zsym(996, "Symbols"),
    Zxxx(997, "Code for unwritten documents"),
    Zyyy(998, "Code for undetermined script"),
    Zzzz(999, "Code for uncoded script");

    private final int numeric;
    private final String english;
    private static ISO15924[] staticValues;

    private ISO15924(int numeric, String english) {
        this.numeric = numeric;
        this.english = english;
    }

    public String code4() {
        return this.name();
    }

    public int numeric() {
        return this.numeric;
    }

    public String englishName() {
        return this.english;
    }

    int getNativeCode() {
        return this.numeric;
    }

    static ISO15924 lookupByNativeCode(int nativeCode) {
        for (ISO15924 v : staticValues) {
            if (v.getNativeCode() != nativeCode) continue;
            return v;
        }
        throw new RuntimeException("Invalid ISO15924 native code " + nativeCode);
    }

    public static ISO15924 lookupByNumeric(int numeric) {
        return ISO15924.lookupByNativeCode(numeric);
    }

    public static ISO15924 lookupByCode4(String code4) {
        for (ISO15924 v : staticValues) {
            if (!code4.equals(v.toString())) continue;
            return v;
        }
        return null;
    }

    static {
        staticValues = ISO15924.values();
    }
}

