/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.MapAttribute;
import com.basistech.rosette.dm.jackson.KnownAttribute;
import com.basistech.rosette.dm.jackson.KnownKey;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class MapAttributeDeserializer
extends JsonDeserializer<MapAttribute> {
    public MapAttribute deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            jp.nextToken();
        } else if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "MapAttributeDeserializer called not at or FIELD_NAME of first field");
        }
        TokenBuffer tb = null;
        String keyName = null;
        String valueName = null;
        JsonToken t = jp.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            if ("keyType".equals(name)) {
                keyName = this.getName(jp);
            }
            if ("valueType".equals(name)) {
                valueName = this.getName(jp);
            }
            if (keyName != null && valueName != null) {
                return this.deserialize(jp, ctxt, tb, keyName, valueName);
            }
            if (tb == null) {
                tb = new TokenBuffer(null, false);
            }
            if (!"keyType".equals(name) && !"valueType".equals(name)) {
                tb.copyCurrentStructure(jp);
            }
            t = jp.nextToken();
        }
        if (keyName == null) {
            throw ctxt.mappingException("No keyType provided in a map");
        }
        throw ctxt.mappingException("No valueType provided in a map");
    }

    private String getName(JsonParser jp) throws IOException {
        jp.nextToken();
        return jp.getText();
    }

    private <K, V> TypeReference<Map<K, V>> buildTypeReference(Class<K> keyClass, Class<V> valueClass) {
        final TypeToken tok = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyClass).where(new TypeParameter<V>(){}, valueClass);
        return new TypeReference<Map<K, V>>(){

            public Type getType() {
                return tok.getType();
            }
        };
    }

    private MapAttribute deserialize(JsonParser jp, DeserializationContext ctxt, TokenBuffer tb, String keyName, String valueName) throws IOException {
        JsonToken nextToken;
        if (tb != null) {
            jp = JsonParserSequence.createFlattened((boolean)false, (JsonParser)tb.asParser(jp), (JsonParser)jp);
        }
        KnownKey key = KnownKey.getKnownForKey(keyName);
        KnownAttribute attribute = KnownAttribute.getAttributeForKey(valueName);
        if (key == null) {
            key = KnownKey.UNKNOWN;
        }
        if (attribute == null) {
            attribute = KnownAttribute.UNKNOWN;
        }
        Class<?> keyClass = key.keyClass();
        Class<? extends BaseAttribute> valueClass = attribute.attributeClass();
        MapAttribute.Builder builder = new MapAttribute.Builder(keyClass, valueClass);
        HashMap items = Maps.newHashMap();
        while ((nextToken = jp.nextToken()) != JsonToken.END_OBJECT) {
            if (nextToken != JsonToken.FIELD_NAME) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_OBJECT, "Expected field name.");
            }
            String name = jp.getCurrentName();
            if ("items".equals(name)) {
                nextToken = jp.nextToken();
                if (nextToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                    Object o = jp.getEmbeddedObject();
                    if (o instanceof Map) {
                        items.putAll((Map)o);
                        continue;
                    }
                    throw ctxt.mappingException("Map contains VALUE_EMBEDDED_OBJECT for items, but it wasn't a map.");
                }
                if (nextToken != JsonToken.START_OBJECT) {
                    throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "Expected object of items");
                }
                items.putAll((Map)jp.readValueAs(this.buildTypeReference(keyClass, valueClass)));
                continue;
            }
            nextToken = jp.nextToken();
            Object value = nextToken == JsonToken.VALUE_EMBEDDED_OBJECT ? jp.getEmbeddedObject() : jp.readValueAs(Object.class);
            builder.extendedProperty(name, value);
        }
        builder.setItems((Map)items);
        return builder.build();
    }
}

