/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.basistech.rosette.dm.MapAttribute;
import com.basistech.rosette.dm.jackson.KnownAttribute;
import com.basistech.rosette.dm.jackson.KnownKey;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.Map;

public class MapAttributeSerializer
extends JsonSerializer<MapAttribute> {
    public void serialize(MapAttribute value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("keyType", KnownKey.getKeyForClass(value.getKeyClass()).key());
        gen.writeStringField("valueType", KnownAttribute.getAttributeForClass(value.getValueClass()).key());
        gen.writeObjectField("items", (Object)value.getItems());
        this.writeExtendedProperties(value, gen);
        gen.writeEndObject();
    }

    private void writeExtendedProperties(MapAttribute value, JsonGenerator jgen) throws IOException {
        Map extendedProperties = value.getExtendedProperties();
        if (extendedProperties != null && !extendedProperties.isEmpty()) {
            for (Map.Entry entry : extendedProperties.entrySet()) {
                jgen.writeObjectField((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void serializeWithType(MapAttribute value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, jgen);
        KnownKey keyForKeyClass = KnownKey.getKeyForClass(value.getKeyClass());
        KnownAttribute attributeForValueClass = KnownAttribute.getAttributeForClass(value.getValueClass());
        assert (keyForKeyClass != null);
        assert (attributeForValueClass != null);
        jgen.writeStringField("keyType", keyForKeyClass.key());
        jgen.writeStringField("valueType", attributeForValueClass.key());
        jgen.writeObjectField("items", (Object)value.getItems());
        this.writeExtendedProperties(value, jgen);
        typeSer.writeTypeSuffixForObject((Object)value, jgen);
    }
}

