/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson.array;

import com.basistech.rosette.dm.ListAttribute;
import com.basistech.rosette.dm.jackson.KnownAttribute;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.Map;

public class ListAttributeArraySerializer
extends JsonSerializer<ListAttribute> {
    public void serialize(ListAttribute value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        jgen.writeString(KnownAttribute.getAttributeForClass(value.getItemClass()).key());
        this.writeItems(value, jgen, provider);
        this.writeExtendedProperties(value, jgen);
        jgen.writeEndArray();
    }

    private void writeItems(ListAttribute value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (Object attr : value) {
            provider.defaultSerializeValue(attr, jgen);
        }
        jgen.writeEndArray();
    }

    private void writeExtendedProperties(ListAttribute value, JsonGenerator jgen) throws IOException {
        Map extendedProperties = value.getExtendedProperties();
        jgen.writeStartObject();
        for (Map.Entry entry : extendedProperties.entrySet()) {
            jgen.writeObjectField((String)entry.getKey(), entry.getValue());
        }
        jgen.writeEndObject();
    }

    public void serializeWithType(ListAttribute value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForArray((Object)value, jgen);
        jgen.writeString(KnownAttribute.getAttributeForClass(value.getItemClass()).key());
        this.writeItems(value, jgen, provider);
        this.writeExtendedProperties(value, jgen);
        typeSer.writeTypeSuffixForArray((Object)value, jgen);
    }
}

