/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson.array;

import com.basistech.rosette.dm.MorphoAnalysis;
import com.basistech.rosette.dm.jackson.array.MorphoAnalysisTypes;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class MorphoAnalysisListArrayDeserializer
extends JsonDeserializer<List<MorphoAnalysis>> {
    public List<MorphoAnalysis> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "Expected array of items");
        }
        ArrayList results = Lists.newArrayList();
        MorphoAnalysisTypes type = MorphoAnalysisTypes.PLAIN;
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            if (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
                type = MorphoAnalysisTypes.byOrdinal(jp.getIntValue());
                jp.nextToken();
            }
            results.add(jp.readValueAs(type.getMorphoAnalysisClass()));
        }
        return ImmutableList.copyOf((Collection)results);
    }
}

