/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class DoubleSerializer
extends StdSerializer<Double> {
    private final NumberFormat numberFormat;

    public DoubleSerializer() {
        super(Double.class);
        NumberFormat f = NumberFormat.getInstance(Locale.US);
        if (f instanceof DecimalFormat) {
            f.setMaximumFractionDigits(8);
        }
        f.setGroupingUsed(false);
        this.numberFormat = f;
    }

    public void serialize(Double value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeNumber(Double.parseDouble(this.numberFormat.format(value)));
    }
}

