/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.basistech.rosette.dm.UnknownAttribute;
import com.basistech.util.LanguageCode;

public enum KnownKey {
    STRING("string", String.class),
    LANGUAGE_CODE("languageCode", LanguageCode.class),
    UNKNOWN("unknown", UnknownAttribute.class);

    private final String jsonTag;
    private final Class<?> attributeClass;

    private KnownKey(String jsonTag, Class<?> keyClass) {
        this.jsonTag = jsonTag;
        this.attributeClass = keyClass;
    }

    public String key() {
        return this.jsonTag;
    }

    public Class<?> keyClass() {
        return this.attributeClass;
    }

    public static KnownKey getKnownForKey(String key) {
        for (KnownKey item : KnownKey.values()) {
            if (!item.key().equals(key)) continue;
            return item;
        }
        return null;
    }

    public static KnownKey getKeyForClass(Class<?> attributeClass) {
        for (KnownKey item : KnownKey.values()) {
            if (!item.keyClass().equals(attributeClass)) continue;
            return item;
        }
        return null;
    }
}

