/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.ListAttribute;
import com.basistech.rosette.dm.jackson.KnownAttribute;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ListAttributeDeserializer
extends JsonDeserializer<ListAttribute> {
    public ListAttribute deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            jp.nextToken();
        } else if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "ListAttributeDeserializer called not at or FIELD_NAME of first field");
        }
        TokenBuffer tb = null;
        JsonToken t = jp.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            if ("itemType".equals(name)) {
                return this.deserialize(jp, ctxt, tb);
            }
            if (tb == null) {
                tb = new TokenBuffer(null, false);
            }
            tb.copyCurrentStructure(jp);
            t = jp.nextToken();
        }
        throw ctxt.mappingException("No itemType provided in a list");
    }

    private ListAttribute deserialize(JsonParser jp, DeserializationContext ctxt, TokenBuffer tb) throws IOException {
        JsonToken nextToken;
        KnownAttribute attribute;
        jp.nextToken();
        String keyName = jp.getText();
        if (tb != null) {
            jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
        }
        if ((attribute = KnownAttribute.getAttributeForKey(keyName)) == null) {
            attribute = KnownAttribute.UNKNOWN;
        }
        Class<? extends BaseAttribute> itemClass = attribute.attributeClass();
        ListAttribute.Builder builder = new ListAttribute.Builder(attribute.attributeClass());
        ArrayList items = Lists.newArrayList();
        while ((nextToken = jp.nextToken()) != JsonToken.END_OBJECT) {
            if (nextToken != JsonToken.FIELD_NAME) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_OBJECT, "Expected field name.");
            }
            String name = jp.getCurrentName();
            if ("items".equals(name)) {
                nextToken = jp.nextToken();
                if (nextToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                    Object o = jp.getEmbeddedObject();
                    if (o instanceof List) {
                        items.addAll((List)o);
                        continue;
                    }
                    throw ctxt.mappingException("List contains VALUE_EMBEDDED_OBJECT for items, but it wasn't a list.");
                }
                if (nextToken != JsonToken.START_ARRAY) {
                    throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "Expected array of items");
                }
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    items.add(jp.readValueAs(itemClass));
                }
                continue;
            }
            nextToken = jp.nextToken();
            Object value = nextToken == JsonToken.VALUE_EMBEDDED_OBJECT ? jp.getEmbeddedObject() : jp.readValueAs(Object.class);
            builder.extendedProperty(name, value);
        }
        builder.setItems((List)items);
        return builder.build();
    }
}

