/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson.array;

import com.basistech.rosette.dm.MorphoAnalysis;
import com.basistech.rosette.dm.jackson.array.MorphoAnalysisTypes;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;

public class MorphoAnalysisListArraySerializer
extends JsonSerializer<List<MorphoAnalysis>> {
    public void serialize(List<MorphoAnalysis> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        MorphoAnalysisTypes curType = MorphoAnalysisTypes.PLAIN;
        for (MorphoAnalysis ma : value) {
            MorphoAnalysisTypes type = MorphoAnalysisTypes.byClass(ma.getClass());
            if (curType != type) {
                jgen.writeNumber(type.ordinal());
                curType = type;
            }
            jgen.writeObject((Object)ma);
        }
        jgen.writeEndArray();
    }
}

