/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import java.beans.ConstructorProperties;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public final class LanguageWeight {
    private final LanguageCode language;
    private final ISO15924 script;
    @Min(value=0L)
    @Max(value=100L)
    private final Integer weight;

    @ConstructorProperties(value={"language", "script", "weight"})
    LanguageWeight(LanguageCode language, ISO15924 script, Integer weight) {
        this.language = language;
        this.script = script;
        this.weight = weight;
    }

    public static LanguageWeightBuilder builder() {
        return new LanguageWeightBuilder();
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public ISO15924 getScript() {
        return this.script;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LanguageWeight)) {
            return false;
        }
        LanguageWeight other = (LanguageWeight)o;
        LanguageCode this$language = this.getLanguage();
        LanguageCode other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        ISO15924 this$script = this.getScript();
        ISO15924 other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        Integer this$weight = this.getWeight();
        Integer other$weight = other.getWeight();
        return !(this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LanguageCode $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        ISO15924 $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        Integer $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        return result;
    }

    public String toString() {
        return "LanguageWeight(language=" + this.getLanguage() + ", script=" + this.getScript() + ", weight=" + this.getWeight() + ")";
    }

    public static class LanguageWeightBuilder {
        private LanguageCode language;
        private ISO15924 script;
        private Integer weight;

        LanguageWeightBuilder() {
        }

        public LanguageWeightBuilder language(LanguageCode language) {
            this.language = language;
            return this;
        }

        public LanguageWeightBuilder script(ISO15924 script) {
            this.script = script;
            return this;
        }

        public LanguageWeightBuilder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public LanguageWeight build() {
            return new LanguageWeight(this.language, this.script, this.weight);
        }

        public String toString() {
            return "LanguageWeight.LanguageWeightBuilder(language=" + this.language + ", script=" + this.script + ", weight=" + this.weight + ")";
        }
    }
}

