/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import javax.validation.constraints.NotNull;

public final class Name {
    @NotNull
    private final String text;
    private final String entityType;
    private final ISO15924 script;
    private final LanguageCode language;

    public Name(String name, String entityType, ISO15924 script, LanguageCode language) {
        this.text = name;
        this.entityType = entityType;
        this.script = script;
        this.language = language;
    }

    public Name(String name) {
        this.text = name;
        this.entityType = "PERSON";
        this.script = ISO15924.Zyyy;
        this.language = LanguageCode.UNKNOWN;
    }

    public static NameBuilder builder() {
        return new NameBuilder();
    }

    public String getText() {
        return this.text;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public ISO15924 getScript() {
        return this.script;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name other = (Name)o;
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        ISO15924 this$script = this.getScript();
        ISO15924 other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        LanguageCode this$language = this.getLanguage();
        LanguageCode other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        ISO15924 $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        LanguageCode $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    public String toString() {
        return "Name(text=" + this.getText() + ", entityType=" + this.getEntityType() + ", script=" + this.getScript() + ", language=" + this.getLanguage() + ")";
    }

    public static class NameBuilder {
        private String text;
        private String entityType;
        private ISO15924 script;
        private LanguageCode language;

        NameBuilder() {
        }

        public NameBuilder text(String text) {
            this.text = text;
            return this;
        }

        public NameBuilder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public NameBuilder script(ISO15924 script) {
            this.script = script;
            return this;
        }

        public NameBuilder language(LanguageCode language) {
            this.language = language;
            return this;
        }

        public Name build() {
            return new Name(this.text, this.entityType, this.script, this.language);
        }

        public String toString() {
            return "Name.NameBuilder(text=" + this.text + ", entityType=" + this.entityType + ", script=" + this.script + ", language=" + this.language + ")";
        }
    }
}

