/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import java.beans.ConstructorProperties;

public final class SupportedLanguage {
    private final LanguageCode language;
    private final ISO15924 script;

    @ConstructorProperties(value={"language", "script"})
    SupportedLanguage(LanguageCode language, ISO15924 script) {
        this.language = language;
        this.script = script;
    }

    public static SupportedLanguageBuilder builder() {
        return new SupportedLanguageBuilder();
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public ISO15924 getScript() {
        return this.script;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupportedLanguage)) {
            return false;
        }
        SupportedLanguage other = (SupportedLanguage)o;
        LanguageCode this$language = this.getLanguage();
        LanguageCode other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        ISO15924 this$script = this.getScript();
        ISO15924 other$script = other.getScript();
        return !(this$script == null ? other$script != null : !this$script.equals(other$script));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LanguageCode $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        ISO15924 $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        return result;
    }

    public String toString() {
        return "SupportedLanguage(language=" + this.getLanguage() + ", script=" + this.getScript() + ")";
    }

    public static class SupportedLanguageBuilder {
        private LanguageCode language;
        private ISO15924 script;

        SupportedLanguageBuilder() {
        }

        public SupportedLanguageBuilder language(LanguageCode language) {
            this.language = language;
            return this;
        }

        public SupportedLanguageBuilder script(ISO15924 script) {
            this.script = script;
            return this;
        }

        public SupportedLanguage build() {
            return new SupportedLanguage(this.language, this.script);
        }

        public String toString() {
            return "SupportedLanguage.SupportedLanguageBuilder(language=" + this.language + ", script=" + this.script + ")";
        }
    }
}

