/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.examples;

import com.basistech.rosette.api.HttpRosetteAPI;
import com.basistech.rosette.apimodel.Name;
import com.basistech.rosette.apimodel.NameDeduplicationRequest;
import com.basistech.rosette.apimodel.NameDeduplicationResponse;
import com.basistech.rosette.apimodel.Request;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.examples.ExampleBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public final class NameDeduplicationExample
extends ExampleBase {
    public static void main(String[] args) {
        try {
            new NameDeduplicationExample().run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException {
        String nameDedupeData = "John Smith,Johnathon Smith,Fred Jones";
        ArrayList<String> listOfNames = new ArrayList<String>(Arrays.asList(nameDedupeData.split(",")));
        ArrayList<Name> names = new ArrayList<Name>();
        for (String name : listOfNames) {
            names.add(Name.builder().text(name).build());
        }
        double threshold = 0.75;
        HttpRosetteAPI rosetteApi = new HttpRosetteAPI.Builder().key(this.getApiKeyFromSystemProperty()).url(this.getAltUrlFromSystemProperty()).build();
        NameDeduplicationRequest request = NameDeduplicationRequest.builder().names(names).threshold(Double.valueOf(threshold)).build();
        NameDeduplicationResponse response = (NameDeduplicationResponse)rosetteApi.perform("/name-deduplication", (Request)request, NameDeduplicationResponse.class);
        System.out.println(NameDeduplicationExample.responseToJson((Response)response));
    }
}

