/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Dependency
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final String relationship;
    private final int governorTokenIndex;
    private final int dependencyTokenIndex;

    protected Dependency(String relationship, int governorTokenIndex, int dependencyTokenIndex, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.relationship = relationship;
        this.governorTokenIndex = governorTokenIndex;
        this.dependencyTokenIndex = dependencyTokenIndex;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public int getGovernorTokenIndex() {
        return this.governorTokenIndex;
    }

    public int getDependencyTokenIndex() {
        return this.dependencyTokenIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.governorTokenIndex == that.governorTokenIndex && this.dependencyTokenIndex == that.dependencyTokenIndex && Objects.equals(this.relationship, that.relationship);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relationship, this.governorTokenIndex, this.dependencyTokenIndex);
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("relationship", this.relationship).add("dependencyTokenIndex", this.dependencyTokenIndex).add("governorTokenIndex", this.governorTokenIndex);
    }

    public static class Builder
    extends BaseAttribute.Builder<Dependency, Builder> {
        private String relationship;
        private int governorTokenIndex;
        private int dependencyTokenIndex;

        public Builder(String relationship, int governorTokenIndex, int dependencyTokenIndex) {
            this.relationship = relationship;
            this.governorTokenIndex = governorTokenIndex;
            this.dependencyTokenIndex = dependencyTokenIndex;
        }

        public Builder(Dependency toCopy) {
            super(toCopy);
            this.relationship = toCopy.relationship;
            this.governorTokenIndex = toCopy.governorTokenIndex;
            this.dependencyTokenIndex = toCopy.dependencyTokenIndex;
        }

        public Dependency build() {
            return new Dependency(this.relationship, this.governorTokenIndex, this.dependencyTokenIndex, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

