/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.Attribute;
import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class LanguageDetection
extends Attribute
implements Serializable {
    private static final long serialVersionUID = 250L;
    private final List<DetectionResult> detectionResults;

    protected LanguageDetection(int startOffset, int endOffset, List<DetectionResult> detectionResults, Map<String, Object> extendedProperties) {
        super(startOffset, endOffset, extendedProperties);
        this.detectionResults = LanguageDetection.listOrNull(detectionResults);
    }

    public List<DetectionResult> getDetectionResults() {
        return this.detectionResults;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("detectionResults", this.detectionResults);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LanguageDetection that = (LanguageDetection)o;
        return this.detectionResults.equals(that.detectionResults);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.detectionResults.hashCode();
        return result;
    }

    public static class Builder
    extends Attribute.Builder<LanguageDetection, Builder> {
        private List<DetectionResult> detectionResults;

        public Builder(int startOffset, int endOffset, List<DetectionResult> detectionResults) {
            super(startOffset, endOffset);
            this.detectionResults = detectionResults;
        }

        public Builder(LanguageDetection toCopy) {
            super(toCopy);
            this.detectionResults = Lists.newArrayList();
            Builder.addAllToList(this.detectionResults, toCopy.detectionResults);
        }

        public LanguageDetection build() {
            return new LanguageDetection(this.startOffset, this.endOffset, this.detectionResults, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }

    public static class DetectionResult
    extends BaseAttribute {
        private final LanguageCode language;
        private final String encoding;
        private final ISO15924 script;
        private final Double confidence;

        protected DetectionResult(LanguageCode language, String encoding, ISO15924 script, Double confidence, Map<String, Object> extendedProperties) {
            super(extendedProperties);
            this.language = language;
            this.encoding = encoding;
            this.script = script;
            this.confidence = confidence;
        }

        public LanguageCode getLanguage() {
            return this.language;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public ISO15924 getScript() {
            return this.script;
        }

        public Double getConfidence() {
            return this.confidence;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DetectionResult that = (DetectionResult)o;
            if (this.confidence != null ? !this.confidence.equals(that.confidence) : that.confidence != null) {
                return false;
            }
            if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) {
                return false;
            }
            if (this.language != that.language) {
                return false;
            }
            return this.script == that.script;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
            result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
            result = 31 * result + (this.script != null ? this.script.hashCode() : 0);
            result = 31 * result + (this.confidence != null ? this.confidence.hashCode() : 0);
            return result;
        }

        @Override
        protected MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("language", this.language).add("encoding", this.encoding).add("script", this.script).add("confidence", this.confidence);
        }

        public static class Builder
        extends BaseAttribute.Builder<DetectionResult, Builder> {
            private LanguageCode language;
            private String encoding;
            private ISO15924 script;
            private Double confidence;

            public Builder(LanguageCode language) {
                this.language = language;
            }

            public Builder(DetectionResult toCopy) {
                super(toCopy);
                this.language = toCopy.getLanguage();
                this.encoding = toCopy.getEncoding();
                this.script = toCopy.getScript();
                this.confidence = toCopy.getConfidence();
            }

            public Builder language(LanguageCode language) {
                this.language = language;
                return this;
            }

            public Builder encoding(String encoding) {
                this.encoding = encoding;
                return this;
            }

            public Builder script(ISO15924 script) {
                this.script = script;
                return this;
            }

            public Builder confidence(Double confidence) {
                this.confidence = confidence;
                return this;
            }

            public DetectionResult build() {
                return new DetectionResult(this.language, this.encoding, this.script, this.confidence, this.buildExtendedProperties());
            }

            @Override
            protected Builder getThis() {
                return this;
            }
        }
    }
}

