/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MapAttribute<K, V extends BaseAttribute>
extends BaseAttribute
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 250L;
    private final Map<K, V> items;
    private final Class<?> keyClass;
    private final Class<? extends BaseAttribute> valueClass;

    protected MapAttribute(Class<?> keyClass, Class<? extends BaseAttribute> valueClass, Map<K, V> items) {
        this.items = items;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    protected MapAttribute(Class<?> keyClass, Class<? extends BaseAttribute> valueClass, Map<K, V> items, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.items = items;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    public Map<K, V> getItems() {
        return this.items;
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public Class<? extends BaseAttribute> getValueClass() {
        return this.valueClass;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.items.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.items.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)((BaseAttribute)this.items.get(key));
    }

    @Override
    public V put(K key, V value) {
        throw MapAttribute.readOnly();
    }

    @Override
    public V remove(Object key) {
        throw MapAttribute.readOnly();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw MapAttribute.readOnly();
    }

    @Override
    public void clear() {
        throw MapAttribute.readOnly();
    }

    @Override
    public Set<K> keySet() {
        return this.items.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.items.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.items.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.items.equals(o);
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("items", this.items).add("keyClass", this.keyClass).add("valueClass", this.valueClass);
    }

    private static RuntimeException readOnly() {
        return new UnsupportedOperationException("MapAttribute is read-only");
    }

    public static class Builder<K, V extends BaseAttribute>
    extends BaseAttribute.Builder<MapAttribute<K, V>, Builder<K, V>> {
        private Class<?> keyClass;
        private Class<? extends BaseAttribute> valueClass;
        private Map<K, V> items;

        public Builder(Class<?> keyClass, Class<? extends BaseAttribute> valueClass) {
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            this.items = Maps.newHashMap();
        }

        public Builder<K, V> put(K key, V value) {
            this.items.put(key, value);
            return this;
        }

        public Builder<K, V> setItems(Map<K, V> items) {
            this.items = items;
            return this;
        }

        public MapAttribute<K, V> build() {
            return new MapAttribute<K, V>(this.keyClass, this.valueClass, this.items, this.buildExtendedProperties());
        }

        @Override
        protected Builder<K, V> getThis() {
            return this;
        }
    }
}

