/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.Transliteration;
import com.basistech.shaded.dm.com.google.common.base.MoreObjects;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableMap;
import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import java.util.HashMap;
import java.util.Map;

public final class TransliterationResults
extends BaseAttribute {
    private final Map<LanguageCode, Transliteration> results;

    protected TransliterationResults(Map<LanguageCode, Transliteration> results, Map<String, Object> extendedAttributes) {
        super(extendedAttributes);
        ImmutableMap.Builder<LanguageCode, Transliteration> mapBuilder = ImmutableMap.builder();
        for (LanguageCode lc : results.keySet()) {
            mapBuilder.put(lc, results.get(lc));
        }
        this.results = mapBuilder.build();
    }

    public Map<LanguageCode, Transliteration> getResults() {
        return this.results;
    }

    public Transliteration getTransliteration(LanguageCode code) {
        return this.getResults().get(code);
    }

    public String getTransliterationInScript(LanguageCode code, ISO15924 script) {
        Transliteration t = this.getTransliteration(code);
        if (t == null) {
            return null;
        }
        return t.get(script);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransliterationResults that = (TransliterationResults)o;
        return this.results != null ? this.results.equals(that.results) : that.results == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.results != null ? this.results.hashCode() : 0);
        return result;
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("results", this.results);
    }

    public static class Builder
    extends BaseAttribute.Builder<TransliterationResults, Builder> {
        private Map<LanguageCode, Transliteration.Builder> results;

        public Builder(LanguageCode languageCode, ISO15924 script, String transliteration) {
            this.results = new HashMap<LanguageCode, Transliteration.Builder>();
            this.results.put(languageCode, Transliteration.Builder.of(script, transliteration));
        }

        public Builder() {
            this.results = new HashMap<LanguageCode, Transliteration.Builder>();
        }

        public Builder(TransliterationResults other) {
            this.results = this.copy(other.results);
        }

        private Map<LanguageCode, Transliteration.Builder> copy(Map<LanguageCode, Transliteration> otherResults) {
            HashMap<LanguageCode, Transliteration.Builder> output = new HashMap<LanguageCode, Transliteration.Builder>(otherResults.size());
            for (LanguageCode lang : otherResults.keySet()) {
                output.put(lang, Transliteration.Builder.of(otherResults.get(lang)));
            }
            return output;
        }

        public Builder addTransliteration(LanguageCode languageCode, Transliteration transliteration) {
            if (this.results.containsKey(languageCode)) {
                this.results.get(languageCode).add(transliteration);
            } else {
                this.results.put(languageCode, Transliteration.Builder.of(transliteration));
            }
            return this;
        }

        public Builder transliteration(Map<LanguageCode, Transliteration> transliterations) {
            this.results = this.copy(transliterations);
            return this;
        }

        public Builder clearResults() {
            this.results.clear();
            return this;
        }

        public TransliterationResults build() {
            HashMap<LanguageCode, Transliteration> finalResults = new HashMap<LanguageCode, Transliteration>();
            for (LanguageCode l : this.results.keySet()) {
                finalResults.put(l, this.results.get(l).build());
            }
            return new TransliterationResults(finalResults, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

