/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.util;

import com.basistech.rosette.RosetteUnsupportedLanguageException;
import com.basistech.rosette.dm.AnnotatedText;
import com.basistech.rosette.dm.Annotator;
import com.basistech.rosette.dm.LanguageDetection;
import com.basistech.util.LanguageCode;
import java.util.Map;

public class WholeDocumentLanguageDispatchAnnotator
implements Annotator {
    private final Map<LanguageCode, Annotator> delegates;

    WholeDocumentLanguageDispatchAnnotator(Map<LanguageCode, Annotator> delegates) {
        this.delegates = delegates;
    }

    @Override
    public AnnotatedText annotate(CharSequence input) {
        throw new UnsupportedOperationException("No AnnotatedText provided.");
    }

    @Override
    public AnnotatedText annotate(AnnotatedText input) {
        LanguageDetection languageDetection = input.getWholeTextLanguageDetection();
        if (languageDetection == null || languageDetection.getDetectionResults().size() == 0) {
            throw new IllegalArgumentException("No whole document language detection in the input.");
        }
        Annotator delegate = this.delegates.get(languageDetection.getDetectionResults().get(0).getLanguage());
        if (delegate == null) {
            throw new RosetteUnsupportedLanguageException(languageDetection.getDetectionResults().get(0).getLanguage());
        }
        return delegate.annotate(input);
    }
}

