/*
 * Decompiled with CFR 0.152.
 */
package com.betfair.baseline.v1;

import com.betfair.baseline.v1.BaselineServiceDefinition;
import com.betfair.baseline.v1.BaselineSyncClient;
import com.betfair.baseline.v1.enumerations.SimpleExceptionErrorCodeEnum;
import com.betfair.baseline.v1.exception.SimpleException;
import com.betfair.baseline.v1.to.SimpleResponse;
import com.betfair.cougar.api.ContainerContext;
import com.betfair.cougar.api.ExecutionContext;
import com.betfair.cougar.core.api.ServiceVersion;
import com.betfair.cougar.core.api.ev.ExecutionObserver;
import com.betfair.cougar.core.api.ev.ExecutionResult;
import com.betfair.cougar.core.api.ev.ExecutionVenue;
import com.betfair.cougar.core.api.ev.OperationKey;
import com.betfair.cougar.core.api.ev.TimeConstraints;
import com.betfair.cougar.core.api.ev.WaitingObserver;
import com.betfair.cougar.core.api.exception.CougarClientException;
import com.betfair.cougar.core.api.exception.CougarException;
import com.betfair.cougar.core.api.exception.CougarFrameworkException;
import com.betfair.cougar.core.api.exception.ServerFaultCode;
import com.betfair.cougar.core.impl.CougarInternalOperations;
import com.betfair.cougar.core.impl.DefaultTimeConstraints;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class BaselineSyncClientImpl
implements BaselineSyncClient {
    private static final ServiceVersion serviceVersion = new ServiceVersion("v1.0");
    private ExecutionVenue ev;
    private String namespace;

    protected BaselineSyncClientImpl() {
    }

    protected void setEv(ExecutionVenue ev) {
        this.ev = ev;
    }

    protected void setNamespace(String namespace) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("Namespace must be a non-empty string: " + namespace);
        }
        this.namespace = namespace;
    }

    public BaselineSyncClientImpl(ExecutionVenue ev) {
        this(ev, CougarInternalOperations.COUGAR_IN_PROCESS_NAMESPACE);
    }

    public BaselineSyncClientImpl(ExecutionVenue ev, String namespace) {
        this.setEv(ev);
        this.setNamespace(namespace);
    }

    private OperationKey getOperationKey(OperationKey key) {
        return this.namespace == null ? key : new OperationKey(key, this.namespace);
    }

    @Override
    public SimpleResponse testSimpleGet(ExecutionContext ctx, String message, long timeoutMillis) throws TimeoutException, InterruptedException, SimpleException {
        return this.testSimpleGet(ctx, message, DefaultTimeConstraints.fromTimeout((long)timeoutMillis));
    }

    public SimpleResponse testSimpleGet(ExecutionContext ctx, String message, TimeConstraints timeConstraints) throws TimeoutException, InterruptedException, SimpleException {
        WaitingObserver observer = new WaitingObserver();
        this.ev.execute(ctx, this.getOperationKey(BaselineServiceDefinition.testSimpleGetKey), new Object[]{message}, (ExecutionObserver)observer, timeConstraints);
        if (!observer.await(timeConstraints)) {
            throw new CougarClientException(ServerFaultCode.Timeout, "Operation testSimpleGet timed out!");
        }
        ExecutionResult er = observer.getExecutionResult();
        switch (er.getResultType()) {
            case Success: {
                return (SimpleResponse)er.getResult();
            }
            case Fault: {
                CougarException cex = er.getFault();
                if (cex.getServerFaultCode() == ServerFaultCode.ServiceCheckedException) {
                    List exceptionParams = cex.getFault().getDetail().getFaultMessages();
                    String className = cex.getFault().getDetail().getDetailMessage();
                    if (className.equals("SimpleException")) {
                        throw new SimpleException(cex.getResponseCode(), SimpleExceptionErrorCodeEnum.valueOf(((String[])exceptionParams.get(0))[1]), ((String[])exceptionParams.get(1))[1]);
                    }
                    throw new IllegalArgumentException("An unanticipated exception was received of class [" + className + "]");
                }
                if (cex instanceof CougarFrameworkException) {
                    CougarFrameworkException cfe = (CougarFrameworkException)cex;
                    throw new CougarClientException(cfe.getServerFaultCode(), cfe.getMessage(), cfe.getCause());
                }
                throw cex;
            }
        }
        throw new IllegalArgumentException("The Server returned an illegal result type [" + er.getResultType() + "]");
    }

    @Override
    public SimpleResponse testSimpleGet(ExecutionContext ctx, String message) throws SimpleException {
        try {
            return this.testSimpleGet(ctx, message, DefaultTimeConstraints.NO_CONSTRAINTS);
        }
        catch (TimeoutException ex) {
        }
        catch (InterruptedException interrupted) {
            throw new RuntimeException("Operation testSimpleGet was interrupted!");
        }
        return null;
    }

    public void init(ContainerContext cc) {
        throw new UnsupportedOperationException("Not valid for CLIENT");
    }
}

