/*
 * Decompiled with CFR 0.152.
 */
package com.betfair.baseline.v1.exception;

import com.betfair.baseline.v1.enumerations.SimpleExceptionErrorCodeEnum;
import com.betfair.cougar.api.ResponseCode;
import com.betfair.cougar.api.fault.CougarApplicationException;
import com.betfair.cougar.core.api.ServiceVersion;
import com.betfair.cougar.core.api.transcription.EnumUtils;
import com.betfair.cougar.core.api.transcription.Parameter;
import com.betfair.cougar.core.api.transcription.ParameterType;
import com.betfair.cougar.core.api.transcription.Transcribable;
import com.betfair.cougar.core.api.transcription.TranscribableParams;
import com.betfair.cougar.core.api.transcription.TranscriptionInput;
import com.betfair.cougar.core.api.transcription.TranscriptionOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SimpleException
extends CougarApplicationException
implements Transcribable {
    private static final String prefix = "SEX-";
    private static final Parameter __responseCodeParameter = new Parameter("responseCode", new ParameterType(ResponseCode.class, null), false);
    private static final Parameter __stackSizeParameter = new Parameter("stackSize", new ParameterType(Integer.class, null), false);
    private static final Parameter __stackClassNameParameter = new Parameter("stackClass", new ParameterType(String.class, null), false);
    private static final Parameter __stackMethodNameParameter = new Parameter("stackMethod", new ParameterType(String.class, null), false);
    private static final Parameter __stackFileNameParameter = new Parameter("stackFile", new ParameterType(String.class, null), false);
    private static final Parameter __stackLineNumberParameter = new Parameter("stackLineNo", new ParameterType(Integer.class, null), false);
    private static final Parameter __errorCodeParameter = new Parameter("errorCode", new ParameterType(SimpleExceptionErrorCodeEnum.class, null), false);
    protected SimpleExceptionErrorCodeEnum errorCode;
    private String rawErrorCodeValue;
    private static final Parameter __reasonParameter = new Parameter("reason", new ParameterType(String.class, null), false);
    protected String reason;
    public static final ServiceVersion SERVICE_VERSION = new ServiceVersion("v1.0");
    public static final Parameter[] PARAMETERS = new Parameter[]{__responseCodeParameter, __errorCodeParameter, __reasonParameter, __stackSizeParameter, __stackClassNameParameter, __stackMethodNameParameter, __stackFileNameParameter, __stackLineNumberParameter};

    public final SimpleExceptionErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    private final void setErrorCode(SimpleExceptionErrorCodeEnum errorCode) {
        if (errorCode == SimpleExceptionErrorCodeEnum.UNRECOGNIZED_VALUE) {
            throw new IllegalArgumentException("UNRECOGNIZED_VALUE reserved for soft enum deserialisation handling");
        }
        this.errorCode = errorCode;
        this.rawErrorCodeValue = errorCode != null ? errorCode.name() : null;
    }

    public final String getRawErrorCodeValue() {
        return this.rawErrorCodeValue;
    }

    private final void setRawErrorCodeValue(String errorCode) {
        SimpleExceptionErrorCodeEnum enumValue;
        this.errorCode = enumValue = errorCode != null ? (SimpleExceptionErrorCodeEnum)EnumUtils.readEnum(SimpleExceptionErrorCodeEnum.class, (String)errorCode) : null;
        this.rawErrorCodeValue = errorCode;
    }

    public final String getReason() {
        return this.reason;
    }

    private final void setReason(String reason) {
        this.reason = reason;
    }

    public SimpleException(ResponseCode responseCode, SimpleExceptionErrorCodeEnum errorCode, String reason) {
        super(responseCode, prefix + errorCode.getCode());
        this.setErrorCode(errorCode);
        this.setReason(reason);
    }

    private SimpleException(ResponseCode responseCode, String errorCode, String reason) {
        super(responseCode, prefix + errorCode);
        this.setRawErrorCodeValue(errorCode);
        this.setReason(reason);
    }

    public SimpleException(SimpleExceptionErrorCodeEnum errorCode, String reason) {
        this(ResponseCode.BusinessException, errorCode, reason);
    }

    public SimpleException(TranscriptionInput in, Set<TranscribableParams> _transcriptionParams) throws Exception {
        this((ResponseCode)in.readObject(__responseCodeParameter, true), SimpleException.readErrorCode(in, _transcriptionParams), (String)in.readObject(__reasonParameter, true));
        this.transcribeStackTrace(in);
    }

    private static String readErrorCode(TranscriptionInput in, Set<TranscribableParams> _transcriptionParams) throws Exception {
        if (_transcriptionParams.contains(TranscribableParams.EnumsWrittenAsStrings)) {
            return (String)in.readObject(__errorCodeParameter, true);
        }
        SimpleExceptionErrorCodeEnum errorCode = (SimpleExceptionErrorCodeEnum)in.readObject(__errorCodeParameter, true);
        return errorCode != null ? errorCode.name() : null;
    }

    public SimpleException(Throwable cause, ResponseCode responseCode, SimpleExceptionErrorCodeEnum errorCode, String reason) {
        super(responseCode, prefix + errorCode.getCode(), cause);
        this.setErrorCode(errorCode);
        this.setReason(reason);
    }

    public List<String[]> getApplicationFaultMessages() {
        ArrayList<String[]> appFaults = new ArrayList<String[]>();
        appFaults.add(new String[]{"errorCode", String.valueOf(this.errorCode)});
        appFaults.add(new String[]{"reason", String.valueOf(this.reason)});
        return appFaults;
    }

    public String getApplicationFaultNamespace() {
        return "http://www.betfair.com/servicetypes/v1/Baseline/";
    }

    public Parameter[] getParameters() {
        return PARAMETERS;
    }

    public void transcribe(TranscriptionOutput out, Set<TranscribableParams> _transcriptionParams, boolean client) throws Exception {
        out.writeObject((Object)this.getResponseCode(), __responseCodeParameter, client);
        if (_transcriptionParams.contains(TranscribableParams.EnumsWrittenAsStrings)) {
            out.writeObject((Object)(this.getErrorCode() != null ? this.getErrorCode().name() : null), __errorCodeParameter, client);
        } else {
            out.writeObject((Object)this.getErrorCode(), __errorCodeParameter, client);
        }
        out.writeObject((Object)this.getReason(), __reasonParameter, client);
        this.transcribeStackTrace(out);
    }

    public void transcribe(TranscriptionInput in, Set<TranscribableParams> params, boolean client) throws Exception {
    }

    public ServiceVersion getServiceVersion() {
        return SERVICE_VERSION;
    }

    private void transcribeStackTrace(TranscriptionOutput out) throws Exception {
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackTrace != null) {
            out.writeObject((Object)stackTrace.length, __stackSizeParameter, false);
            for (StackTraceElement element : stackTrace) {
                out.writeObject((Object)element.getClassName(), __stackClassNameParameter, false);
                out.writeObject((Object)element.getMethodName(), __stackMethodNameParameter, false);
                out.writeObject((Object)element.getFileName(), __stackFileNameParameter, false);
                out.writeObject((Object)element.getLineNumber(), __stackLineNumberParameter, false);
            }
        } else {
            out.writeObject(null, __stackSizeParameter, false);
        }
    }

    private void transcribeStackTrace(TranscriptionInput in) throws Exception {
        Integer size = (Integer)in.readObject(__stackSizeParameter, true);
        if (size != null) {
            StackTraceElement[] stackTrace = new StackTraceElement[size.intValue()];
            for (int i = 0; i < stackTrace.length; ++i) {
                stackTrace[i] = new StackTraceElement((String)in.readObject(__stackClassNameParameter, true), (String)in.readObject(__stackMethodNameParameter, true), (String)in.readObject(__stackFileNameParameter, true), (Integer)in.readObject(__stackLineNumberParameter, true));
            }
            this.setStackTrace(stackTrace);
        }
    }

    public String getMessage() {
        return "responseCode=" + this.getResponseCode() + ", errorCode=" + this.errorCode + " (" + prefix + this.errorCode.getCode() + ")" + ", reason=" + this.reason;
    }
}

