/*
 * Copyright 2013, The Sporting Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.betfair.cougar.transport.socket;

import com.betfair.cougar.core.api.RequestTimer;
import com.betfair.cougar.logging.CougarLogger;
import com.betfair.cougar.logging.CougarLoggingUtils;
import com.betfair.cougar.transport.api.protocol.CougarObjectInput;
import com.betfair.cougar.transport.api.protocol.CougarObjectOutput;
import org.apache.mina.common.IoSession;

import java.util.concurrent.atomic.AtomicReference;

public class SocketTransportRPCCommandImpl extends SocketTransportCommandImpl implements SocketTransportRPCCommand {

	private final CougarObjectOutput output;

    private RequestTimer timer = new RequestTimer();
    private IoSession session;

    public SocketTransportRPCCommandImpl(CougarObjectInput input, CougarObjectOutput output, String remoteAddress, IoSession session) {
        super(input, remoteAddress, session);
		this.output = output;
	}

	@Override
	public CougarObjectOutput getOutput() {
		return output;
	}
}
