/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainOperator;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ArithmeticOperatorType {
    PLUS("+", DomainOperator.PLUS),
    MINUS("-", DomainOperator.MINUS),
    MULTIPLY("*", DomainOperator.MULTIPLICATION),
    DIVIDE("/", DomainOperator.DIVISION),
    MODULO("%", DomainOperator.MODULO);

    private static final Map<String, ArithmeticOperatorType> OPERATOR_MAP;
    private final String operator;
    private final DomainOperator domainOperator;

    private ArithmeticOperatorType(String operator, DomainOperator domainOperator) {
        this.operator = operator;
        this.domainOperator = domainOperator;
    }

    public String getOperator() {
        return this.operator;
    }

    public DomainOperator getDomainOperator() {
        return this.domainOperator;
    }

    public static ArithmeticOperatorType valueOfOperator(String operator) {
        ArithmeticOperatorType operatorType = OPERATOR_MAP.get(operator);
        if (operatorType == null) {
            throw new IllegalArgumentException("Invalid operator: " + operator);
        }
        return operatorType;
    }

    static {
        HashMap<String, ArithmeticOperatorType> operatorMap = new HashMap<String, ArithmeticOperatorType>();
        for (ArithmeticOperatorType operatorType : EnumSet.allOf(ArithmeticOperatorType.class)) {
            operatorMap.put(operatorType.getOperator(), operatorType);
        }
        OPERATOR_MAP = Collections.unmodifiableMap(operatorMap);
    }
}

