/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.AbstractPredicate;
import com.blazebit.expression.ArithmeticExpression;
import com.blazebit.expression.Expression;
import java.util.Objects;

public final class BetweenPredicate
extends AbstractPredicate {
    private final ArithmeticExpression left;
    private final ArithmeticExpression upper;
    private final ArithmeticExpression lower;

    public BetweenPredicate(DomainType type, ArithmeticExpression left, ArithmeticExpression upper, ArithmeticExpression lower) {
        super(type);
        this.left = left;
        this.upper = upper;
        this.lower = lower;
    }

    public BetweenPredicate(DomainType type, ArithmeticExpression left, ArithmeticExpression upper, ArithmeticExpression lower, boolean negated) {
        super(type, negated);
        this.left = left;
        this.upper = upper;
        this.lower = lower;
    }

    public ArithmeticExpression getLeft() {
        return this.left;
    }

    public ArithmeticExpression getUpper() {
        return this.upper;
    }

    public ArithmeticExpression getLower() {
        return this.lower;
    }

    @Override
    public BetweenPredicate negated() {
        return new BetweenPredicate(this.getType(), this.left, this.upper, this.lower, !this.isNegated());
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.upper, that.upper) && Objects.equals(this.lower, that.lower);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.left, this.upper, this.lower);
    }
}

