/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.AbstractExpression;
import com.blazebit.expression.ArithmeticExpression;
import com.blazebit.expression.ArithmeticOperatorType;
import com.blazebit.expression.Expression;
import java.util.Objects;

public final class ChainingArithmeticExpression
extends AbstractExpression
implements ArithmeticExpression {
    private final ArithmeticExpression left;
    private final ArithmeticExpression right;
    private final ArithmeticOperatorType operator;

    public ChainingArithmeticExpression(DomainType type, ArithmeticExpression left, ArithmeticExpression right, ArithmeticOperatorType operator) {
        super(type);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public ArithmeticExpression getLeft() {
        return this.left;
    }

    public ArithmeticExpression getRight() {
        return this.right;
    }

    public ArithmeticOperatorType getOperator() {
        return this.operator;
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChainingArithmeticExpression that = (ChainingArithmeticExpression)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.left, this.right, this.operator});
    }
}

