/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainPredicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ComparisonOperator {
    GREATER(">", DomainPredicate.RELATIONAL),
    GREATER_OR_EQUAL(">=", DomainPredicate.RELATIONAL),
    LOWER("<", DomainPredicate.RELATIONAL),
    LOWER_OR_EQUAL("<=", DomainPredicate.RELATIONAL),
    EQUAL("=", DomainPredicate.EQUALITY),
    NOT_EQUAL("!=", DomainPredicate.EQUALITY);

    private static final Map<String, ComparisonOperator> OPERATOR_MAP;
    private final String operator;
    private final DomainPredicate domainPredicate;

    private ComparisonOperator(String operator, DomainPredicate domainPredicate) {
        this.operator = operator;
        this.domainPredicate = domainPredicate;
    }

    public String getOperator() {
        return this.operator;
    }

    public DomainPredicate getDomainPredicate() {
        return this.domainPredicate;
    }

    public static ComparisonOperator valueOfOperator(String operator) {
        ComparisonOperator operatorType = OPERATOR_MAP.get(operator);
        if (operatorType == null) {
            throw new IllegalArgumentException("Invalid operator: " + operator);
        }
        return operatorType;
    }

    static {
        HashMap<String, ComparisonOperator> operatorMap = new HashMap<String, ComparisonOperator>();
        for (ComparisonOperator operatorType : ComparisonOperator.values()) {
            operatorMap.put(operatorType.getOperator(), operatorType);
        }
        operatorMap.put("<>", NOT_EQUAL);
        OPERATOR_MAP = Collections.unmodifiableMap(operatorMap);
    }
}

