/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.AbstractPredicate;
import com.blazebit.expression.ArithmeticExpression;
import com.blazebit.expression.ComparisonOperator;
import com.blazebit.expression.Expression;
import java.util.Objects;

public final class ComparisonPredicate
extends AbstractPredicate {
    private final ArithmeticExpression left;
    private final ArithmeticExpression right;
    private final ComparisonOperator operator;

    public ComparisonPredicate(DomainType type, ArithmeticExpression left, ArithmeticExpression right, ComparisonOperator operator) {
        super(type);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public ComparisonPredicate(DomainType type, ArithmeticExpression left, ArithmeticExpression right, ComparisonOperator operator, boolean negated) {
        super(type, negated);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public ArithmeticExpression getLeft() {
        return this.left;
    }

    public ArithmeticExpression getRight() {
        return this.right;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    @Override
    public ComparisonPredicate negated() {
        return new ComparisonPredicate(this.getType(), this.left, this.right, this.operator, !this.isNegated());
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComparisonPredicate that = (ComparisonPredicate)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.left, this.right, this.operator});
    }
}

