/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.AbstractPredicate;
import com.blazebit.expression.Expression;
import com.blazebit.expression.Predicate;
import java.util.List;

public final class CompoundPredicate
extends AbstractPredicate {
    private final boolean conjunction;
    private final List<Predicate> predicates;

    public CompoundPredicate(DomainType type, List<Predicate> predicates, boolean conjunction) {
        this(type, predicates, conjunction, false);
    }

    public CompoundPredicate(DomainType type, List<Predicate> predicates, boolean conjunction, boolean negated) {
        super(type, negated);
        this.predicates = predicates;
        this.conjunction = conjunction;
    }

    public boolean isConjunction() {
        return this.conjunction;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public CompoundPredicate negated() {
        return new CompoundPredicate(this.getType(), this.predicates, this.conjunction, !this.isNegated());
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompoundPredicate)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompoundPredicate that = (CompoundPredicate)o;
        if (this.conjunction != that.conjunction) {
            return false;
        }
        return this.getPredicates().equals(that.getPredicates());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.conjunction ? 1 : 0);
        result = 31 * result + this.getPredicates().hashCode();
        return result;
    }
}

