/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.boot.model.MetadataDefinitionHolder;
import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.spi.DomainSerializer;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class DocumentationMetadataDefinition
implements MetadataDefinition<DocumentationMetadataDefinition>,
DomainSerializer<DocumentationMetadataDefinition>,
Serializable {
    public static final String LOCALE_PROPERTY = "locale";
    public static final String DEFAULT_BASE_NAME = "resource-bundles/blaze-expression";
    private final String documentation;
    private final Locale defaultLocale;
    private final String baseName;
    private final transient ClassLoader classLoader;

    public DocumentationMetadataDefinition(String documentation) {
        if (documentation == null) {
            throw new IllegalArgumentException("Null documentation");
        }
        this.documentation = DocumentationMetadataDefinition.serialize(documentation);
        this.defaultLocale = null;
        this.baseName = null;
        this.classLoader = null;
    }

    private DocumentationMetadataDefinition(String documentation, Locale defaultLocale, String baseName, ClassLoader classLoader) {
        if (documentation == null) {
            throw new IllegalArgumentException("Null documentation");
        }
        this.documentation = documentation;
        this.defaultLocale = defaultLocale;
        this.baseName = baseName;
        this.classLoader = classLoader;
    }

    public static DocumentationMetadataDefinition localized(String documentationKey) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DocumentationMetadataDefinition.class.getClassLoader();
        }
        return new DocumentationMetadataDefinition(documentationKey, Locale.ENGLISH, DEFAULT_BASE_NAME, classLoader);
    }

    public static DocumentationMetadataDefinition localized(String documentationKey, ClassLoader classLoader) {
        return new DocumentationMetadataDefinition(documentationKey, Locale.ENGLISH, DEFAULT_BASE_NAME, classLoader);
    }

    public static DocumentationMetadataDefinition localized(String documentationKey, String resourceBundleBaseName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DocumentationMetadataDefinition.class.getClassLoader();
        }
        return new DocumentationMetadataDefinition(documentationKey, Locale.ENGLISH, resourceBundleBaseName, classLoader);
    }

    public static DocumentationMetadataDefinition localized(String documentationKey, String resourceBundleBaseName, ClassLoader classLoader) {
        return new DocumentationMetadataDefinition(documentationKey, Locale.ENGLISH, resourceBundleBaseName, classLoader);
    }

    public static DocumentationMetadataDefinition localized(String documentationKey, Locale defaultLocale) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DocumentationMetadataDefinition.class.getClassLoader();
        }
        return new DocumentationMetadataDefinition(documentationKey, defaultLocale, DEFAULT_BASE_NAME, classLoader);
    }

    public static DocumentationMetadataDefinition localized(String documentationKey, Locale defaultLocale, ClassLoader classLoader) {
        return new DocumentationMetadataDefinition(documentationKey, defaultLocale, DEFAULT_BASE_NAME, classLoader);
    }

    public static DocumentationMetadataDefinition localized(String documentationKey, Locale defaultLocale, String resourceBundleBaseName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DocumentationMetadataDefinition.class.getClassLoader();
        }
        return new DocumentationMetadataDefinition(documentationKey, defaultLocale, resourceBundleBaseName, classLoader);
    }

    public static DocumentationMetadataDefinition localized(String documentationKey, Locale defaultLocale, String resourceBundleBaseName, ClassLoader classLoader) {
        return new DocumentationMetadataDefinition(documentationKey, defaultLocale, resourceBundleBaseName, classLoader);
    }

    private static String serialize(String documentation) {
        StringBuilder sb = new StringBuilder(documentation.length() + 9);
        sb.append("{\"doc\":\"");
        for (int i = 0; i < documentation.length(); ++i) {
            char c = documentation.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append("\"}");
        return sb.toString();
    }

    public <T> T serialize(DomainModel domainModel, DocumentationMetadataDefinition element, Class<T> targetType, String format, Map<String, Object> properties) {
        if (targetType != String.class || !"json".equals(format)) {
            return null;
        }
        if (this.defaultLocale == null) {
            return (T)this.documentation;
        }
        Object o = properties.get(LOCALE_PROPERTY);
        Locale locale = o instanceof Locale ? (Locale)o : this.defaultLocale;
        return (T)DocumentationMetadataDefinition.serialize(ResourceBundle.getBundle(this.baseName, locale, this.classLoader).getString(this.documentation));
    }

    public Class<DocumentationMetadataDefinition> getJavaType() {
        return DocumentationMetadataDefinition.class;
    }

    public DocumentationMetadataDefinition build(MetadataDefinitionHolder definitionHolder) {
        return this;
    }
}

