/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.expression.Expression;
import com.blazebit.expression.ExpressionCompiler;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.ExpressionSerializer;
import com.blazebit.expression.Expressions;
import com.blazebit.expression.spi.BooleanLiteralResolver;
import com.blazebit.expression.spi.CollectionLiteralResolver;
import com.blazebit.expression.spi.EntityLiteralResolver;
import com.blazebit.expression.spi.EnumLiteralResolver;
import com.blazebit.expression.spi.ExpressionSerializerFactory;
import com.blazebit.expression.spi.ExpressionServiceSerializer;
import com.blazebit.expression.spi.NumericLiteralResolver;
import com.blazebit.expression.spi.StringLiteralResolver;
import com.blazebit.expression.spi.TemporalLiteralResolver;
import java.util.List;
import java.util.Map;

public interface ExpressionService {
    public DomainModel getDomainModel();

    default public ExpressionService withSubDomainModel(DomainModel subDomainModel) {
        return Expressions.getDefaultProvider().createBuilder(this, subDomainModel).build();
    }

    public Map<Class<?>, ExpressionSerializerFactory<?>> getExpressionSerializerFactories();

    public List<ExpressionServiceSerializer<?>> getExpressionServiceSerializers();

    public ExpressionCompiler createCompiler();

    public ExpressionInterpreter createInterpreter();

    public ExpressionSerializer<StringBuilder> createSerializer();

    public ExpressionSerializer<StringBuilder> createTemplateSerializer();

    public <T> ExpressionSerializer<T> createSerializer(Class<T> var1);

    public NumericLiteralResolver getNumericLiteralResolver();

    public BooleanLiteralResolver getBooleanLiteralResolver();

    public StringLiteralResolver getStringLiteralResolver();

    public TemporalLiteralResolver getTemporalLiteralResolver();

    public EnumLiteralResolver getEnumLiteralResolver();

    public EntityLiteralResolver getEntityLiteralResolver();

    public CollectionLiteralResolver getCollectionLiteralResolver();

    default public <T> T serialize(Class<T> targetType, String format, Map<String, Object> properties) {
        return this.serialize(null, targetType, format, properties);
    }

    public <T> T serialize(ExpressionService var1, Class<T> var2, String var3, Map<String, Object> var4);

    default public String serialize(Expression expression) {
        ExpressionSerializer<StringBuilder> serializer = this.createSerializer(StringBuilder.class);
        StringBuilder sb = new StringBuilder();
        serializer.serializeTo(expression, sb);
        return sb.toString();
    }
}

