/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.expression.ExpressionService;
import com.blazebit.expression.spi.ExpressionServiceBuilderProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class Expressions {
    private static volatile ExpressionServiceBuilderProvider defaultProvider;

    private Expressions() {
    }

    public static ExpressionService forModel(DomainModel model) {
        return Expressions.getDefaultProvider().createDefaultBuilder(model).build();
    }

    public static ExpressionServiceBuilderProvider getDefaultProvider() {
        ExpressionServiceBuilderProvider provider = defaultProvider;
        if (provider == null) {
            Iterator<ExpressionServiceBuilderProvider> iterator = ServiceLoader.load(ExpressionServiceBuilderProvider.class).iterator();
            if (iterator.hasNext()) {
                defaultProvider = iterator.next();
                return defaultProvider;
            }
            throw new IllegalStateException("No expression service factory provider available. Did you forget to add the expression-impl dependency?");
        }
        return provider;
    }
}

