/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.AbstractPredicate;
import com.blazebit.expression.ArithmeticExpression;
import com.blazebit.expression.Expression;
import java.util.List;
import java.util.Objects;

public final class InPredicate
extends AbstractPredicate {
    private final ArithmeticExpression left;
    private final List<ArithmeticExpression> inItems;

    public InPredicate(DomainType type, ArithmeticExpression left, List<ArithmeticExpression> inItems) {
        super(type);
        this.left = left;
        this.inItems = inItems;
    }

    public InPredicate(DomainType type, ArithmeticExpression left, List<ArithmeticExpression> inItems, boolean negated) {
        super(type, negated);
        this.left = left;
        this.inItems = inItems;
    }

    public ArithmeticExpression getLeft() {
        return this.left;
    }

    public List<ArithmeticExpression> getInItems() {
        return this.inItems;
    }

    @Override
    public InPredicate negated() {
        return new InPredicate(this.getType(), this.left, this.inItems, !this.isNegated());
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InPredicate that = (InPredicate)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.inItems, that.inItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.left, this.inItems);
    }
}

