/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression;

import com.blazebit.expression.ArithmeticExpression;
import com.blazebit.expression.ArithmeticFactor;
import com.blazebit.expression.BetweenPredicate;
import com.blazebit.expression.ChainingArithmeticExpression;
import com.blazebit.expression.CollectionLiteral;
import com.blazebit.expression.ComparisonPredicate;
import com.blazebit.expression.CompoundPredicate;
import com.blazebit.expression.EntityLiteral;
import com.blazebit.expression.EnumLiteral;
import com.blazebit.expression.Expression;
import com.blazebit.expression.ExpressionPredicate;
import com.blazebit.expression.FunctionInvocation;
import com.blazebit.expression.InPredicate;
import com.blazebit.expression.IsEmptyPredicate;
import com.blazebit.expression.IsNullPredicate;
import com.blazebit.expression.Literal;
import com.blazebit.expression.Path;
import com.blazebit.expression.Predicate;
import java.util.List;

public abstract class VisitorAdapter
implements Expression.Visitor {
    @Override
    public void visit(ArithmeticFactor e) {
        e.getExpression().accept(this);
    }

    @Override
    public void visit(ExpressionPredicate e) {
        e.getExpression().accept(this);
    }

    @Override
    public void visit(BetweenPredicate e) {
        e.getLeft().accept(this);
        e.getLower().accept(this);
        e.getUpper().accept(this);
    }

    @Override
    public void visit(InPredicate e) {
        e.getLeft().accept(this);
        List<ArithmeticExpression> inItems = e.getInItems();
        for (int i = 0; i < inItems.size(); ++i) {
            inItems.get(i).accept(this);
        }
    }

    @Override
    public void visit(ChainingArithmeticExpression e) {
        e.getLeft().accept(this);
        e.getRight().accept(this);
    }

    @Override
    public void visit(CompoundPredicate e) {
        List<Predicate> predicates = e.getPredicates();
        for (int i = 0; i < predicates.size(); ++i) {
            predicates.get(i).accept(this);
        }
    }

    @Override
    public void visit(ComparisonPredicate e) {
        e.getLeft().accept(this);
        e.getRight().accept(this);
    }

    @Override
    public void visit(IsNullPredicate e) {
        e.getLeft().accept(this);
    }

    @Override
    public void visit(IsEmptyPredicate e) {
        e.getLeft().accept(this);
    }

    @Override
    public void visit(FunctionInvocation e) {
        for (Expression value : e.getArguments().values()) {
            value.accept(this);
        }
    }

    @Override
    public void visit(Path e) {
    }

    @Override
    public void visit(Literal e) {
    }

    @Override
    public void visit(EnumLiteral e) {
    }

    @Override
    public void visit(EntityLiteral e) {
    }

    @Override
    public void visit(CollectionLiteral e) {
    }
}

