/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.job;

import com.blazebit.job.JobException;
import java.util.function.Function;

public interface ConfigurationSource {
    public Object getProperty(String var1);

    default public <T> T getPropertyOrFail(String key, Class<T> type, Function<String, T> stringConverter) {
        return (T)this.getPropertyOrDefault(key, type, stringConverter, o -> {
            if (o == null) {
                throw new JobException("Missing a value for configuration property " + key + "!");
            }
            throw new JobException("Invalid value for configuration property " + key + "! Expected value of type " + type.getName() + " but got: " + o);
        });
    }

    default public <T> T getPropertyOrDefault(String key, Class<T> type, Function<String, T> stringConverter, Function<Object, T> defaultFunction) {
        Object o = this.getProperty(key);
        if (o == null) {
            return defaultFunction.apply(o);
        }
        if (!type.isInstance(o)) {
            if (stringConverter != null) {
                return stringConverter.apply(o.toString());
            }
            return defaultFunction.apply(o);
        }
        return type.cast(o);
    }
}

