/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.job;

import com.blazebit.actor.ActorContext;
import com.blazebit.actor.ActorContextBuilder;
import com.blazebit.job.ConfigurationSource;
import com.blazebit.job.JobException;
import com.blazebit.job.JobInstance;
import com.blazebit.job.JobInstanceListener;
import com.blazebit.job.JobInstanceProcessor;
import com.blazebit.job.JobInstanceState;
import com.blazebit.job.JobManager;
import com.blazebit.job.JobProcessor;
import com.blazebit.job.JobTrigger;
import com.blazebit.job.JobTriggerListener;
import com.blazebit.job.PartitionKey;
import com.blazebit.job.ServiceProvider;
import com.blazebit.job.spi.JobInstanceProcessorFactory;
import com.blazebit.job.spi.JobManagerFactory;
import com.blazebit.job.spi.JobProcessorFactory;
import com.blazebit.job.spi.JobScheduler;
import com.blazebit.job.spi.JobSchedulerFactory;
import com.blazebit.job.spi.PartitionKeyProvider;
import com.blazebit.job.spi.PartitionKeyProviderFactory;
import com.blazebit.job.spi.ScheduleFactory;
import com.blazebit.job.spi.TransactionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface JobContext
extends ServiceProvider,
ConfigurationSource {
    public TransactionSupport getTransactionSupport();

    public JobManager getJobManager();

    public ScheduleFactory getScheduleFactory();

    public <T extends JobTrigger> JobProcessor<T> getJobProcessor(T var1);

    public <T extends JobInstance<?>> JobInstanceProcessor<?, T> getJobInstanceProcessor(T var1);

    public Collection<PartitionKey> getPartitionKeys();

    public Collection<PartitionKey> getPartitionKeys(JobInstance<?> var1);

    public void refreshJobInstanceSchedules(JobInstance<?> var1);

    public void refreshJobInstanceSchedules(long var1);

    public void refreshJobInstanceSchedules(PartitionKey var1, long var2);

    public void forEachJobInstanceListeners(Consumer<JobInstanceListener> var1);

    public void stop();

    public void stop(long var1, TimeUnit var3) throws InterruptedException;

    public static Builder builder() {
        Builder builder = new Builder();
        builder.loadDefaults();
        return builder;
    }

    public static class BuilderBase<T extends BuilderBase<T>> {
        private TransactionSupport transactionSupport;
        private ActorContext actorContext;
        private ActorContextBuilder actorContextBuilder;
        private JobManagerFactory jobManagerFactory;
        private ScheduleFactory scheduleFactory;
        private JobSchedulerFactory jobSchedulerFactory;
        private JobProcessorFactory jobProcessorFactory;
        private JobInstanceProcessorFactory jobInstanceProcessorFactory;
        private PartitionKeyProviderFactory partitionKeyProviderFactory;
        private PartitionKeyProvider partitionKeyProvider;
        private final Map<PartitionKey, Integer> partitionKeys = new HashMap<PartitionKey, Integer>();
        private final List<JobTriggerListener> jobTriggerListeners = new ArrayList<JobTriggerListener>();
        private final List<JobInstanceListener> jobInstanceListeners = new ArrayList<JobInstanceListener>();
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final Map<Class<?>, Object> serviceMap = new HashMap();

        protected void loadDefaults() {
            this.transactionSupport = BuilderBase.loadFirstServiceOrNone(TransactionSupport.class);
            if (this.transactionSupport == null) {
                this.transactionSupport = TransactionSupport.NOOP;
            }
            this.jobManagerFactory = BuilderBase.loadFirstServiceOrNone(JobManagerFactory.class);
            this.scheduleFactory = BuilderBase.loadFirstServiceOrNone(ScheduleFactory.class);
            this.jobSchedulerFactory = BuilderBase.loadFirstServiceOrNone(JobSchedulerFactory.class);
            this.jobProcessorFactory = BuilderBase.loadFirstServiceOrNone(JobProcessorFactory.class);
            this.jobInstanceProcessorFactory = BuilderBase.loadFirstServiceOrNone(JobInstanceProcessorFactory.class);
            this.partitionKeyProviderFactory = BuilderBase.loadFirstServiceOrNone(PartitionKeyProviderFactory.class);
            this.jobTriggerListeners.addAll(BuilderBase.loadServices(JobTriggerListener.class));
            this.jobInstanceListeners.addAll(BuilderBase.loadServices(JobInstanceListener.class));
        }

        protected static <X> X loadFirstServiceOrNone(Class<X> serviceClass) {
            Iterator<X> scheduleFactoryIterator = ServiceLoader.load(serviceClass).iterator();
            if (scheduleFactoryIterator.hasNext()) {
                X o = scheduleFactoryIterator.next();
                if (scheduleFactoryIterator.hasNext()) {
                    return null;
                }
                return o;
            }
            return null;
        }

        protected static <X> List<X> loadServices(Class<X> serviceClass) {
            ArrayList<X> list = new ArrayList<X>();
            for (X service : ServiceLoader.load(serviceClass)) {
                list.add(service);
            }
            return list;
        }

        protected void checkCreateContext() {
            if (this.getTransactionSupport() == null) {
                throw new JobException("No transaction support given!");
            }
            if (this.getJobManagerFactory() == null) {
                throw new JobException("No job manager factory given!");
            }
            if (this.getScheduleFactory() == null) {
                throw new JobException("No schedule factory given!");
            }
            if (this.getJobSchedulerFactory() == null) {
                throw new JobException("No job scheduler factory given!");
            }
            if (this.getJobProcessorFactory() == null) {
                throw new JobException("No job processor factory given!");
            }
            if (this.getJobInstanceProcessorFactory() == null) {
                throw new JobException("No job instance processor factory given!");
            }
            if (this.getPartitionKeyProviderFactory() == null) {
                throw new JobException("No job instance partition key provider factory given!");
            }
        }

        public JobContext createContext() {
            this.checkCreateContext();
            return new DefaultJobContext(this.transactionSupport, this.getJobManagerFactory(), this.getOrCreateActorContext(), this.getScheduleFactory(), this.getJobSchedulerFactory(), this.getJobProcessorFactory(), this.getJobInstanceProcessorFactory(), this.getPartitionKeyMap(), this.getPartitionKeyProvider(), this.getJobTriggerListeners(), this.getJobInstanceListeners(), this.properties, this.serviceMap);
        }

        protected ActorContext getOrCreateActorContext() {
            ActorContext actorContext = this.getActorContext();
            if (actorContext == null) {
                ActorContextBuilder builder = this.getActorContextBuilder();
                if (builder == null) {
                    builder = ActorContext.builder();
                }
                builder.withProperties(this.properties);
                for (Map.Entry<Class<?>, Object> entry : this.serviceMap.entrySet()) {
                    builder.withService(entry.getKey(), entry.getValue());
                }
                return builder.createContext();
            }
            return actorContext;
        }

        public TransactionSupport getTransactionSupport() {
            return this.transactionSupport;
        }

        public T withTransactionSupport(TransactionSupport transactionSupport) {
            this.transactionSupport = transactionSupport;
            return (T)this;
        }

        public JobManagerFactory getJobManagerFactory() {
            return this.jobManagerFactory;
        }

        public T withJobManagerFactory(JobManagerFactory jobManagerFactory) {
            this.jobManagerFactory = jobManagerFactory;
            return (T)this;
        }

        public ActorContext getActorContext() {
            return this.actorContext;
        }

        public T withActorContext(ActorContext actorContext) {
            this.actorContext = actorContext;
            return (T)this;
        }

        public ActorContextBuilder getActorContextBuilder() {
            return this.actorContextBuilder;
        }

        public T withActorContextBuilder(ActorContextBuilder actorContextBuilder) {
            this.actorContextBuilder = actorContextBuilder;
            return (T)this;
        }

        public ScheduleFactory getScheduleFactory() {
            return this.scheduleFactory;
        }

        public T withScheduleFactory(ScheduleFactory scheduleFactory) {
            this.scheduleFactory = scheduleFactory;
            return (T)this;
        }

        public JobProcessorFactory getJobProcessorFactory() {
            return this.jobProcessorFactory;
        }

        public T withJobProcessorFactory(JobProcessorFactory jobProcessorFactory) {
            this.jobProcessorFactory = jobProcessorFactory;
            return (T)this;
        }

        public JobInstanceProcessorFactory getJobInstanceProcessorFactory() {
            return this.jobInstanceProcessorFactory;
        }

        public T withJobInstanceProcessorFactory(JobInstanceProcessorFactory jobInstanceProcessorFactory) {
            this.jobInstanceProcessorFactory = jobInstanceProcessorFactory;
            return (T)this;
        }

        public JobSchedulerFactory getJobSchedulerFactory() {
            return this.jobSchedulerFactory;
        }

        public T withJobSchedulerFactory(JobSchedulerFactory jobSchedulerFactory) {
            this.jobSchedulerFactory = jobSchedulerFactory;
            return (T)this;
        }

        public Set<PartitionKey> getPartitionKeys() {
            return this.partitionKeys.keySet();
        }

        protected Map<PartitionKey, Integer> getPartitionKeyMap() {
            return this.partitionKeys;
        }

        public T withPartitionKey(PartitionKey partitionKey, int processingCount) {
            this.partitionKeys.put(partitionKey, processingCount);
            return (T)this;
        }

        protected PartitionKeyProvider getPartitionKeyProvider() {
            if (this.partitionKeyProvider == null) {
                this.partitionKeyProvider = this.partitionKeyProviderFactory.createPartitionKeyProvider(new ServiceProvider(){

                    @Override
                    public <T> T getService(Class<T> serviceClass) {
                        return serviceClass.cast(this.getServiceMap().get(serviceClass));
                    }
                }, this::getProperty);
            }
            return this.partitionKeyProvider;
        }

        public PartitionKeyProviderFactory getPartitionKeyProviderFactory() {
            return this.partitionKeyProviderFactory;
        }

        public T withPartitionKeyProviderFactory(PartitionKeyProviderFactory partitionKeyProviderFactory) {
            this.partitionKeyProviderFactory = partitionKeyProviderFactory;
            this.partitionKeyProvider = null;
            return (T)this;
        }

        public List<JobTriggerListener> getJobTriggerListeners() {
            return this.jobTriggerListeners;
        }

        public T withJobTriggerListener(JobTriggerListener jobTriggerListener) {
            this.jobTriggerListeners.add(jobTriggerListener);
            return (T)this;
        }

        public T withJobTriggerListeners(List<JobTriggerListener> jobTriggerListeners) {
            this.jobTriggerListeners.addAll(jobTriggerListeners);
            return (T)this;
        }

        public List<JobInstanceListener> getJobInstanceListeners() {
            return this.jobInstanceListeners;
        }

        public T withJobInstanceListener(JobInstanceListener jobInstanceListener) {
            this.jobInstanceListeners.add(jobInstanceListener);
            return (T)this;
        }

        public T withJobInstanceListeners(List<JobInstanceListener> jobInstanceListeners) {
            this.jobInstanceListeners.addAll(jobInstanceListeners);
            return (T)this;
        }

        protected Map<String, Object> getProperties() {
            return this.properties;
        }

        public Object getProperty(String property) {
            return this.properties.get(property);
        }

        public T withProperty(String property, Object value) {
            this.properties.put(property, value);
            return (T)this;
        }

        public T withProperties(Map<String, Object> properties) {
            this.properties.putAll(properties);
            return (T)this;
        }

        protected Map<Class<?>, Object> getServiceMap() {
            return this.serviceMap;
        }

        public Collection<Object> getServices() {
            return this.serviceMap.values();
        }

        public <X> T withService(Class<X> serviceClass, X service) {
            this.serviceMap.put(serviceClass, service);
            return (T)this;
        }

        protected static class DefaultJobContext
        implements JobContext {
            private static final String DEFAULT_JOB_INSTANCE_ACTOR_NAME = "jobInstanceScheduler";
            private static final int DEFAULT_JOB_INSTANCE_PROCESS_COUNT = 1;
            private static final String DEFAULT_JOB_TRIGGER_ACTOR_NAME = "jobTriggerScheduler";
            private static final int DEFAULT_JOB_TRIGGER_PROCESS_COUNT = 1;
            private final TransactionSupport transactionSupport;
            private final JobManager jobManager;
            private final ScheduleFactory scheduleFactory;
            private final JobProcessorFactory jobProcessorFactory;
            private final JobInstanceProcessorFactory jobInstanceProcessorFactory;
            private final PartitionKeyProvider partitionKeyProvider;
            private final Map<PartitionKey, JobScheduler> jobSchedulers;
            private final Map<Class<?>, List<PartitionKey>> jobInstanceClassToPartitionKeysMapping = new ConcurrentHashMap();
            private final JobInstanceListener[] jobInstanceListeners;
            private final Map<String, Object> properties;
            private final Map<Class<?>, Object> serviceMap;

            protected DefaultJobContext(TransactionSupport transactionSupport, JobManagerFactory jobManagerFactory, ActorContext actorContext, ScheduleFactory scheduleFactory, JobSchedulerFactory jobSchedulerFactory, JobProcessorFactory jobProcessorFactory, JobInstanceProcessorFactory jobInstanceProcessorFactory, Map<PartitionKey, Integer> partitionKeyEntries, PartitionKeyProvider partitionKeyProvider, List<JobTriggerListener> jobTriggerListeners, List<JobInstanceListener> jobInstanceListeners, Map<String, Object> properties, Map<Class<?>, Object> serviceMap) {
                this.transactionSupport = transactionSupport;
                this.scheduleFactory = scheduleFactory;
                this.jobProcessorFactory = jobProcessorFactory;
                this.jobInstanceProcessorFactory = jobInstanceProcessorFactory;
                this.properties = new HashMap<String, Object>(properties);
                this.serviceMap = new HashMap(serviceMap);
                this.jobManager = jobManagerFactory.createJobManager(this);
                if (partitionKeyProvider == null) {
                    throw new JobException("No PartitionKeyProvider given!");
                }
                this.partitionKeyProvider = partitionKeyProvider;
                Collection<PartitionKey> defaultTriggerPartitionKeys = this.partitionKeyProvider.getDefaultTriggerPartitionKeys();
                if (partitionKeyEntries.isEmpty()) {
                    Collection<PartitionKey> instancePartitionKeys = this.partitionKeyProvider.getDefaultJobInstancePartitionKeys();
                    this.jobSchedulers = new HashMap<PartitionKey, JobScheduler>(defaultTriggerPartitionKeys.size() + instancePartitionKeys.size());
                    for (PartitionKey instancePartitionKey : instancePartitionKeys) {
                        JobScheduler jobInstanceScheduler = jobSchedulerFactory.createJobScheduler(this, actorContext, "jobInstanceScheduler/" + instancePartitionKey, 1, instancePartitionKey);
                        this.jobSchedulers.put(instancePartitionKey, jobInstanceScheduler);
                    }
                } else {
                    this.jobSchedulers = new HashMap<PartitionKey, JobScheduler>(defaultTriggerPartitionKeys.size() + partitionKeyEntries.size());
                    for (Map.Entry<PartitionKey, Integer> entry : partitionKeyEntries.entrySet()) {
                        this.jobSchedulers.put(entry.getKey(), jobSchedulerFactory.createJobScheduler(this, actorContext, "jobInstanceScheduler/" + entry.getKey(), entry.getValue(), entry.getKey()));
                    }
                }
                for (PartitionKey jobTriggerPartitionKey : defaultTriggerPartitionKeys) {
                    this.jobSchedulers.put(jobTriggerPartitionKey, jobSchedulerFactory.createJobScheduler(this, actorContext, DEFAULT_JOB_TRIGGER_ACTOR_NAME, 1, jobTriggerPartitionKey));
                }
                jobInstanceListeners.addAll(jobTriggerListeners);
                this.jobInstanceListeners = jobInstanceListeners.toArray(new JobInstanceListener[jobInstanceListeners.size()]);
                this.afterConstruct();
            }

            protected void afterConstruct() {
                this.start();
            }

            protected void start() {
                for (JobScheduler jobScheduler : this.jobSchedulers.values()) {
                    jobScheduler.start();
                }
            }

            @Override
            public Object getProperty(String property) {
                return this.properties.get(property);
            }

            @Override
            public <T> T getService(Class<T> serviceClass) {
                return (T)this.serviceMap.get(serviceClass);
            }

            @Override
            public TransactionSupport getTransactionSupport() {
                return this.transactionSupport;
            }

            @Override
            public JobManager getJobManager() {
                return this.jobManager;
            }

            @Override
            public ScheduleFactory getScheduleFactory() {
                return this.scheduleFactory;
            }

            @Override
            public <T extends JobTrigger> JobProcessor<T> getJobProcessor(T jobTrigger) {
                return this.jobProcessorFactory.createJobProcessor(this, jobTrigger);
            }

            @Override
            public <T extends JobInstance<?>> JobInstanceProcessor<?, T> getJobInstanceProcessor(T jobInstance) {
                if (jobInstance instanceof JobTrigger) {
                    return this.jobProcessorFactory.createJobProcessor(this, (JobTrigger)jobInstance);
                }
                return this.jobInstanceProcessorFactory.createJobInstanceProcessor(this, jobInstance);
            }

            @Override
            public void refreshJobInstanceSchedules(JobInstance<?> jobInstance) {
                if (jobInstance.getState() != JobInstanceState.NEW) {
                    throw new JobException("JobInstance is already done and can't be scheduled: " + jobInstance);
                }
                long earliestNewSchedule = jobInstance.getScheduleTime().toEpochMilli();
                Collection partitionKeys = this.getPartitionKeys((JobInstance)jobInstance);
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    this.jobSchedulers.get(partitionKeys.get(i)).refreshSchedules(earliestNewSchedule);
                }
            }

            @Override
            public Collection<PartitionKey> getPartitionKeys() {
                return Collections.unmodifiableSet(this.jobSchedulers.keySet());
            }

            public List<PartitionKey> getPartitionKeys(JobInstance<?> jobInstance) {
                return this.jobInstanceClassToPartitionKeysMapping.computeIfAbsent(jobInstance.getClass(), k -> {
                    ArrayList<PartitionKey> v = new ArrayList<PartitionKey>(this.jobSchedulers.keySet().size());
                    for (PartitionKey partitionKey : this.jobSchedulers.keySet()) {
                        if (!partitionKey.getJobInstanceType().isAssignableFrom((Class<?>)k)) continue;
                        v.add(partitionKey);
                    }
                    return v;
                });
            }

            @Override
            public void refreshJobInstanceSchedules(long earliestNewSchedule) {
                for (JobScheduler jobScheduler : this.jobSchedulers.values()) {
                    jobScheduler.refreshSchedules(earliestNewSchedule);
                }
            }

            @Override
            public void refreshJobInstanceSchedules(PartitionKey partitionKey, long earliestNewSchedule) {
                JobScheduler jobScheduler = this.jobSchedulers.get(partitionKey);
                if (jobScheduler != null) {
                    jobScheduler.refreshSchedules(earliestNewSchedule);
                }
            }

            @Override
            public void forEachJobInstanceListeners(Consumer<JobInstanceListener> jobInstanceListenerConsumer) {
                for (int i = 0; i < this.jobInstanceListeners.length; ++i) {
                    jobInstanceListenerConsumer.accept(this.jobInstanceListeners[i]);
                }
            }

            @Override
            public void stop() {
                for (JobScheduler jobScheduler : this.jobSchedulers.values()) {
                    jobScheduler.stop();
                }
            }

            @Override
            public void stop(long timeout, TimeUnit unit) throws InterruptedException {
                for (JobScheduler jobScheduler : this.jobSchedulers.values()) {
                    jobScheduler.stop(timeout, unit);
                }
            }
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
    }
}

