/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.job;

import com.blazebit.job.JobConfiguration;
import com.blazebit.job.JobContext;
import com.blazebit.job.JobInstanceProcessingContext;
import com.blazebit.job.JobInstanceState;
import com.blazebit.job.ScheduleContext;
import java.time.Instant;

public interface JobInstance<ID> {
    public ID getId();

    public Long getPartitionKey();

    public JobInstanceState getState();

    public int getDeferCount();

    public void incrementDeferCount();

    public Instant getScheduleTime();

    public void setScheduleTime(Instant var1);

    default public Instant nextSchedule(JobContext jobContext, ScheduleContext scheduleContext) {
        return this.getScheduleTime();
    }

    public Instant getCreationTime();

    public Instant getLastExecutionTime();

    public void setLastExecutionTime(Instant var1);

    default public Object getLastProcessed() {
        return null;
    }

    public void onChunkSuccess(JobInstanceProcessingContext<?> var1);

    public JobConfiguration getJobConfiguration();

    public void markDone(Object var1);

    public void markFailed(Throwable var1);

    default public void markDeferred(Instant newScheduleTime) {
        this.incrementDeferCount();
        int maximumDeferCount = this.getJobConfiguration().getMaximumDeferCount();
        if (maximumDeferCount > -1 && this.getDeferCount() > maximumDeferCount) {
            this.markDropped();
        }
        this.setScheduleTime(newScheduleTime);
    }

    public void markDeadlineReached();

    public void markDropped();
}

