/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.job;

import com.blazebit.job.ScheduleContext;
import java.time.Instant;

public interface Schedule {
    default public Instant nextSchedule() {
        return this.nextSchedule(Schedule.now());
    }

    default public Instant nextSchedule(ScheduleContext ctx) {
        return Instant.ofEpochMilli(this.nextEpochSchedule(ctx));
    }

    default public long nextEpochSchedule() {
        return this.nextEpochSchedule(Schedule.now());
    }

    public long nextEpochSchedule(ScheduleContext var1);

    public static ScheduleContext now() {
        long now = System.currentTimeMillis();
        return Schedule.scheduleContext(now);
    }

    public static ScheduleContext scheduleContext(final long lastScheduleTime) {
        return new ScheduleContext(){

            @Override
            public long getLastScheduleTime() {
                return lastScheduleTime;
            }

            @Override
            public long getLastExecutionTime() {
                return 0L;
            }

            @Override
            public long getLastCompletionTime() {
                return 0L;
            }
        };
    }
}

