/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.job;

import com.blazebit.job.TimeFrameUtils;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.util.Set;

public interface TimeFrame {
    public static Instant getNearestTimeFrameSchedule(Set<? extends TimeFrame> timeFrames, Instant time) {
        if (timeFrames == null || timeFrames.isEmpty()) {
            return time;
        }
        Instant earliestInstant = Instant.MAX;
        for (TimeFrame timeFrame : timeFrames) {
            Instant instant = timeFrame.getEarliestInstant(time);
            if (instant == null) continue;
            if (instant.equals(time)) {
                return time;
            }
            earliestInstant = earliestInstant.isBefore(instant) ? earliestInstant : instant;
        }
        return earliestInstant;
    }

    public static boolean isContained(Set<? extends TimeFrame> timeFrames, Instant time) {
        if (timeFrames != null) {
            for (TimeFrame timeFrame : timeFrames) {
                if (timeFrame.contains(time)) continue;
                return false;
            }
        }
        return true;
    }

    public Year getStartYear();

    public Year getEndYear();

    public Month getStartMonth();

    public Month getEndMonth();

    public DayOfWeek getWeekDay();

    public LocalTime getStartTime();

    public LocalTime getEndTime();

    default public boolean contains(Instant time) {
        OffsetDateTime offsetDateTime = time.atOffset(ZoneOffset.UTC);
        if (this.getStartYear() != null || this.getEndYear() != null) {
            int year = offsetDateTime.getYear();
            if (this.getStartYear() != null && year < this.getStartYear().getValue() || this.getEndYear() != null && year > this.getEndYear().getValue()) {
                return false;
            }
        }
        if (this.getStartMonth() != null || this.getEndMonth() != null) {
            int month = offsetDateTime.getMonthValue();
            if (this.getStartMonth() != null && month < this.getStartMonth().getValue() || this.getEndMonth() != null && month > this.getEndMonth().getValue()) {
                return false;
            }
        }
        if (this.getWeekDay() != null && !this.getWeekDay().equals(offsetDateTime.getDayOfWeek())) {
            return false;
        }
        if (this.getStartTime() != null || this.getEndTime() != null) {
            LocalTime localTime = offsetDateTime.toLocalTime();
            if (this.getStartTime() != null && localTime.isBefore(this.getStartTime()) || this.getEndTime() != null && localTime.isAfter(this.getEndTime())) {
                return false;
            }
        }
        return true;
    }

    default public Instant getEarliestInstant() {
        return this.getEarliestInstant(Instant.now());
    }

    default public Instant getEarliestInstant(Instant fromInstant) {
        OffsetDateTime offsetDateTime = fromInstant.atOffset(ZoneOffset.UTC);
        if (this.getStartTime() != null) {
            if (this.getStartTime().isAfter(offsetDateTime.toLocalTime())) {
                offsetDateTime = offsetDateTime.with(this.getStartTime());
            } else if (this.getEndTime() != null && !this.getEndTime().isBefore(offsetDateTime.toLocalTime())) {
                offsetDateTime = offsetDateTime.withDayOfMonth(offsetDateTime.getDayOfMonth() + 1).with(this.getStartTime());
            }
        }
        if (this.getStartYear() == null) {
            offsetDateTime = TimeFrameUtils.adjustWeekDay(offsetDateTime, this.getWeekDay());
            offsetDateTime = TimeFrameUtils.adjustMonth(offsetDateTime, this.getEndYear(), this.getStartMonth(), this.getEndMonth(), this.getWeekDay());
        } else if (this.getStartYear().getValue() > offsetDateTime.getYear()) {
            offsetDateTime = offsetDateTime.withYear(this.getStartYear().getValue());
            offsetDateTime = TimeFrameUtils.adjustWeekDay(offsetDateTime, this.getWeekDay());
            offsetDateTime = TimeFrameUtils.adjustMonth(offsetDateTime, this.getEndYear(), this.getStartMonth(), this.getEndMonth(), this.getWeekDay());
        } else {
            if (this.getEndYear() == null || this.getEndYear().getValue() <= offsetDateTime.getYear()) {
                return offsetDateTime.toInstant();
            }
            throw new IllegalStateException("Unsatisfiable constraints!");
        }
        if (offsetDateTime == null) {
            return null;
        }
        return offsetDateTime.toInstant();
    }
}

